/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSubPartitionElementFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLPartitionElementFactory
extends OBParserBaseVisitor<PartitionElement>
implements StatementFactory<PartitionElement> {
    private final ParserRuleContext parserRuleContext;

    public MySQLPartitionElementFactory(@NonNull OBParser.Hash_partition_elementContext hashPartitionElementContext) {
        if (hashPartitionElementContext == null) {
            throw new NullPointerException("hashPartitionElementContext is marked non-null but is null");
        }
        this.parserRuleContext = hashPartitionElementContext;
    }

    public MySQLPartitionElementFactory(@NonNull OBParser.Range_partition_elementContext rangePartitionElementContext) {
        if (rangePartitionElementContext == null) {
            throw new NullPointerException("rangePartitionElementContext is marked non-null but is null");
        }
        this.parserRuleContext = rangePartitionElementContext;
    }

    public MySQLPartitionElementFactory(@NonNull OBParser.List_partition_elementContext listPartitionElementContext) {
        if (listPartitionElementContext == null) {
            throw new NullPointerException("listPartitionElementContext is marked non-null but is null");
        }
        this.parserRuleContext = listPartitionElementContext;
    }

    @Override
    public PartitionElement generate() {
        return (PartitionElement)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public PartitionElement visitHash_partition_element(OBParser.Hash_partition_elementContext ctx) {
        HashPartitionElement element = new HashPartitionElement((ParserRuleContext)ctx, MySQLFromReferenceFactory.getRelation(ctx.relation_factor()));
        element.setSchema(MySQLFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setSubPartitionElements((List)this.getSubPartitionElements(ctx.subpartition_list()));
        PartitionOptions options = MySQLSubPartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option());
        if (ctx.INTNUM() != null && options == null) {
            options = new PartitionOptions(ctx.ID());
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.INTNUM() != null && options != null) {
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        element.setPartitionOptions(options);
        return element;
    }

    @Override
    public PartitionElement visitRange_partition_element(OBParser.Range_partition_elementContext ctx) {
        List<Expression> rangeExprs = MySQLSubPartitionElementFactory.getRangePartitionExprs(ctx.range_partition_expr());
        RangePartitionElement element = new RangePartitionElement(ctx, MySQLFromReferenceFactory.getRelation(ctx.relation_factor()), rangeExprs);
        element.setSchema(MySQLFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setSubPartitionElements((List)this.getSubPartitionElements(ctx.subpartition_list()));
        PartitionOptions options = MySQLSubPartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option());
        if (ctx.INTNUM() != null && options == null) {
            options = new PartitionOptions(ctx.ID());
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.INTNUM() != null && options != null) {
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        element.setPartitionOptions(options);
        return element;
    }

    @Override
    public PartitionElement visitList_partition_element(OBParser.List_partition_elementContext ctx) {
        List<Expression> listExprs = MySQLSubPartitionElementFactory.getListPartitionExprs(ctx.list_partition_expr());
        ListPartitionElement element = new ListPartitionElement(ctx, MySQLFromReferenceFactory.getRelation(ctx.relation_factor()), listExprs);
        element.setSchema(MySQLFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setSubPartitionElements((List)this.getSubPartitionElements(ctx.subpartition_list()));
        PartitionOptions options = MySQLSubPartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option());
        if (ctx.INTNUM() != null && options == null) {
            options = new PartitionOptions(ctx.ID());
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.INTNUM() != null && options != null) {
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        element.setPartitionOptions(options);
        return element;
    }

    private List<SubPartitionElement> getSubPartitionElements(OBParser.Subpartition_listContext context) {
        if (context == null) {
            return null;
        }
        if (context.opt_hash_subpartition_list() != null) {
            return context.opt_hash_subpartition_list().hash_subpartition_list().hash_subpartition_element().stream().map(c -> new MySQLSubPartitionElementFactory((OBParser.Hash_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        if (context.opt_range_subpartition_list() != null) {
            return context.opt_range_subpartition_list().range_subpartition_list().range_subpartition_element().stream().map(c -> new MySQLSubPartitionElementFactory((OBParser.Range_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        return context.opt_list_subpartition_list().list_subpartition_list().list_subpartition_element().stream().map(c -> new MySQLSubPartitionElementFactory((OBParser.List_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
    }
}

