/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLDataTypeFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLIndexOptionsFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSortColumnFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.Operator;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnAttributes;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnDefinition;
import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import com.oceanbase.tools.sqlparser.statement.createtable.ForeignReference;
import com.oceanbase.tools.sqlparser.statement.createtable.GenerateOption;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.IndexOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineForeignConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.CompoundExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ExpressionParam;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionCall;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLTableElementFactory
extends OBParserBaseVisitor<TableElement>
implements StatementFactory<TableElement> {
    private final ParserRuleContext parserRuleContext;

    public MySQLTableElementFactory(@NonNull OBParser.Table_elementContext tableElementContext) {
        if (tableElementContext == null) {
            throw new NullPointerException("tableElementContext is marked non-null but is null");
        }
        this.parserRuleContext = tableElementContext;
    }

    public MySQLTableElementFactory(@NonNull OBParser.Column_definitionContext columnDefinitionContext) {
        if (columnDefinitionContext == null) {
            throw new NullPointerException("columnDefinitionContext is marked non-null but is null");
        }
        this.parserRuleContext = columnDefinitionContext;
    }

    public MySQLTableElementFactory(@NonNull OBParser.Out_of_line_indexContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.parserRuleContext = context;
    }

    public MySQLTableElementFactory(@NonNull OBParser.Out_of_line_constraintContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.parserRuleContext = context;
    }

    @Override
    public TableElement generate() {
        return (TableElement)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public TableElement visitOut_of_line_constraint(OBParser.Out_of_line_constraintContext ctx) {
        OutOfLineConstraint constraint;
        if (ctx.out_of_line_unique_index() != null) {
            constraint = new OutOfLineConstraint((ParserRuleContext)ctx, (OutOfLineConstraint)this.visit((ParseTree)ctx.out_of_line_unique_index()));
        } else if (ctx.out_of_line_primary_index() != null) {
            constraint = new OutOfLineConstraint((ParserRuleContext)ctx, (OutOfLineConstraint)this.visit((ParseTree)ctx.out_of_line_primary_index()));
        } else if (ctx.FOREIGN() != null) {
            List<SortColumn> columns = ctx.column_name_list().column_name().stream().map(c -> new SortColumn((ParserRuleContext)c, new ColumnReference((ParserRuleContext)c, null, null, c.getText()))).collect(Collectors.toList());
            constraint = new OutOfLineForeignConstraint(ctx, null, columns, this.visitForeignReference(ctx.references_clause()));
            constraint.setIndexName(ctx.index_name() == null ? null : ctx.index_name().getText());
        } else {
            ConstraintState state = null;
            if (ctx.check_state() != null) {
                state = new ConstraintState(ctx.check_state());
                state.setEnforced(ctx.check_state().NOT() == null);
            }
            constraint = new OutOfLineCheckConstraint((ParserRuleContext)ctx, state, new MySQLExpressionFactory(ctx.expr()).generate());
        }
        if (ctx.opt_constraint_name() != null && ctx.opt_constraint_name().constraint_name() != null) {
            constraint.setConstraintName(ctx.opt_constraint_name().constraint_name().getText());
        }
        return constraint;
    }

    @Override
    public TableElement visitOut_of_line_index(OBParser.Out_of_line_indexContext ctx) {
        String name = ctx.index_name() == null ? null : ctx.index_name().getText();
        OutOfLineIndex index = new OutOfLineIndex(ctx, name, this.getSortColumns(ctx.sort_column_list()));
        index.setIndexOptions(this.getIndexOptions(ctx.index_using_algorithm(), ctx.opt_index_options()));
        index.setSpatial(ctx.SPATIAL() != null);
        index.setFullText(ctx.FULLTEXT() != null);
        return index;
    }

    @Override
    public TableElement visitOut_of_line_primary_index(OBParser.Out_of_line_primary_indexContext ctx) {
        List<SortColumn> columns = ctx.column_name_list().column_name().stream().map(c -> new SortColumn((ParserRuleContext)c, new ColumnReference((ParserRuleContext)c, null, null, c.getText()))).collect(Collectors.toList());
        IndexOptions indexOptions = this.getIndexOptions(ctx.index_using_algorithm(), ctx.opt_index_options());
        ConstraintState state = null;
        if (indexOptions != null) {
            state = ctx.opt_index_options() != null ? new ConstraintState(ctx.opt_index_options()) : new ConstraintState(ctx.index_using_algorithm());
            state.setIndexOptions(indexOptions);
        }
        OutOfLineConstraint constraint = new OutOfLineConstraint(ctx, state, columns);
        constraint.setPrimaryKey(true);
        return constraint;
    }

    @Override
    public TableElement visitOut_of_line_unique_index(OBParser.Out_of_line_unique_indexContext ctx) {
        IndexOptions indexOptions = this.getIndexOptions(ctx.index_using_algorithm(), ctx.opt_index_options());
        ConstraintState state = null;
        if (indexOptions != null) {
            state = ctx.opt_index_options() != null ? new ConstraintState(ctx.opt_index_options()) : new ConstraintState(ctx.index_using_algorithm());
            state.setIndexOptions(indexOptions);
        }
        OutOfLineConstraint constraint = new OutOfLineConstraint(ctx, state, this.getSortColumns(ctx.sort_column_list()));
        constraint.setIndexName(ctx.index_name() == null ? null : ctx.index_name().getText());
        constraint.setUniqueKey(true);
        return constraint;
    }

    @Override
    public TableElement visitColumn_definition(OBParser.Column_definitionContext ctx) {
        ColumnReference r;
        ColumnAttributes attributes;
        DataType dataType = null;
        if (ctx.data_type() != null) {
            dataType = new MySQLDataTypeFactory(ctx.data_type()).generate();
        }
        MySQLColumnRefFactory factory = new MySQLColumnRefFactory(ctx.column_definition_ref());
        ColumnDefinition definition = new ColumnDefinition(ctx, (ColumnReference)factory.generate(), dataType);
        if (ctx.AS() != null) {
            MySQLExpressionFactory exprFactory = new MySQLExpressionFactory(ctx.expr());
            GenerateOption generateOption = new GenerateOption((ParserRuleContext)ctx, (Expression)exprFactory.generate());
            if (ctx.opt_generated_option_list() != null) {
                generateOption.setGenerateOption(ctx.opt_generated_option_list().getText());
            }
            if (ctx.VIRTUAL() != null) {
                generateOption.setType(GenerateOption.Type.VIRTUAL);
            } else if (ctx.STORED() != null) {
                generateOption.setType(GenerateOption.Type.STORED);
            }
            definition.setGenerateOption(generateOption);
        }
        if (ctx.opt_column_attribute_list() != null) {
            attributes = this.visitColumnAttributeList(ctx.opt_column_attribute_list());
            definition.setColumnAttributes(attributes);
        } else if (ctx.opt_generated_column_attribute_list() != null) {
            attributes = this.visitGeneratedColumnAttributeList(ctx.opt_generated_column_attribute_list());
            definition.setColumnAttributes(attributes);
        }
        if (ctx.FIRST() != null) {
            definition.setLocation(new ColumnDefinition.Location(ctx.FIRST().getText(), null));
        } else if (ctx.BEFORE() != null) {
            r = new ColumnReference(ctx.column_name(), null, null, ctx.column_name().getText());
            definition.setLocation(new ColumnDefinition.Location(ctx.BEFORE().getText(), r));
        } else if (ctx.AFTER() != null) {
            r = new ColumnReference(ctx.column_name(), null, null, ctx.column_name().getText());
            definition.setLocation(new ColumnDefinition.Location(ctx.AFTER().getText(), r));
        }
        return definition;
    }

    private ForeignReference visitForeignReference(OBParser.References_clauseContext context) {
        OBParser.Relation_factorContext relationFactor = context.relation_factor();
        String schema = MySQLFromReferenceFactory.getSchemaName(relationFactor);
        String tableName = MySQLFromReferenceFactory.getRelation(relationFactor);
        List<ColumnReference> columns = new ArrayList<ColumnReference>();
        if (context.column_name_list() != null) {
            columns = context.column_name_list().column_name().stream().map(c1 -> new ColumnReference((ParserRuleContext)c1, null, null, c1.getText())).collect(Collectors.toList());
        }
        ForeignReference foreignReference = new ForeignReference(context, schema, tableName, columns);
        if (context.match_action() != null) {
            foreignReference.setMatchOption(ForeignReference.MatchOption.valueOf(context.match_action().getText().toUpperCase()));
        }
        if (context.opt_reference_option_list() != null) {
            Map<String, ForeignReference.OnOption> attributes = this.visitReferenceOptions(context.opt_reference_option_list());
            attributes.putAll(this.visitReferenceOption(context.reference_option()));
            foreignReference.setDeleteOption(attributes.get("DELETE"));
            foreignReference.setUpdateOption(attributes.get("UPDATE"));
        }
        return foreignReference;
    }

    private Map<String, ForeignReference.OnOption> visitReferenceOptions(OBParser.Opt_reference_option_listContext context) {
        HashMap<String, ForeignReference.OnOption> attributes = new HashMap<String, ForeignReference.OnOption>();
        if (context.opt_reference_option_list() != null) {
            attributes.putAll(this.visitReferenceOptions(context.opt_reference_option_list()));
        }
        if (context.reference_option() == null) {
            return attributes;
        }
        attributes.putAll(this.visitReferenceOption(context.reference_option()));
        return attributes;
    }

    private Map<String, ForeignReference.OnOption> visitReferenceOption(OBParser.Reference_optionContext context) {
        HashMap<String, ForeignReference.OnOption> attributes = new HashMap<String, ForeignReference.OnOption>();
        String key = context.DELETE() != null ? "DELETE" : "UPDATE";
        OBParser.Reference_actionContext ctx = context.reference_action();
        if (ctx.RESTRICT() != null) {
            attributes.put(key, ForeignReference.OnOption.RESTRICT);
        } else if (ctx.CASCADE() != null) {
            attributes.put(key, ForeignReference.OnOption.CASCADE);
        } else if (ctx.NULLX() != null) {
            attributes.put(key, ForeignReference.OnOption.SET_NULL);
        } else if (ctx.ACTION() != null) {
            attributes.put(key, ForeignReference.OnOption.NO_ACTION);
        } else {
            attributes.put(key, ForeignReference.OnOption.SET_DEFAULT);
        }
        return attributes;
    }

    private IndexOptions getIndexOptions(OBParser.Index_using_algorithmContext c1, OBParser.Opt_index_optionsContext c2) {
        if (c1 == null && c2 == null) {
            return null;
        }
        if (c2 != null && c1 == null) {
            return new MySQLIndexOptionsFactory(c2).generate();
        }
        if (c2 == null) {
            IndexOptions indexOptions = new IndexOptions(c1);
            indexOptions.setUsingBtree(MySQLTableElementFactory.isUsingBTree(c1));
            indexOptions.setUsingHash(MySQLTableElementFactory.isUsingHash(c1));
            return indexOptions;
        }
        IndexOptions first = this.getIndexOptions(c1, null);
        IndexOptions second = this.getIndexOptions(null, c2);
        if (second.getUsingHash() == null) {
            second.setUsingHash(first.getUsingHash());
        }
        if (second.getUsingBtree() == null) {
            second.setUsingBtree(first.getUsingBtree());
        }
        return second;
    }

    private ColumnAttributes visitGeneratedColumnAttributeList(OBParser.Opt_generated_column_attribute_listContext cxt) {
        ColumnAttributes attributes = new ColumnAttributes(cxt);
        if (cxt.opt_generated_column_attribute_list() != null) {
            attributes.merge(this.visitGeneratedColumnAttributeList(cxt.opt_generated_column_attribute_list()));
        }
        attributes.merge(this.visitGeneratedColumnAttribute(cxt.generated_column_attribute()));
        return attributes;
    }

    private ColumnAttributes visitGeneratedColumnAttribute(OBParser.Generated_column_attributeContext ctx) {
        ColumnAttributes attributes = new ColumnAttributes(ctx);
        if (ctx.ID() != null) {
            attributes.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.COMMENT() != null) {
            attributes.setComment(ctx.STRING_VALUE().getText());
        } else {
            InLineConstraint attribute = new InLineConstraint(ctx, null, null);
            if (ctx.NULLX() != null) {
                attribute.setNullable(ctx.NOT() == null);
                attributes.setConstraints(Collections.singletonList(attribute));
            } else if (ctx.PRIMARY() != null) {
                attribute.setPrimaryKey(true);
                attributes.setConstraints(Collections.singletonList(attribute));
            } else if (ctx.UNIQUE() != null) {
                attribute.setUniqueKey(true);
                attributes.setConstraints(Collections.singletonList(attribute));
            } else if (ctx.KEY() != null) {
                attribute.setPrimaryKey(true);
                attributes.setConstraints(Collections.singletonList(attribute));
            } else if (ctx.CHECK() != null) {
                Expression expr = new MySQLExpressionFactory(ctx.expr()).generate();
                attributes.setConstraints(Collections.singletonList(new InLineCheckConstraint(ctx, null, null, expr)));
            }
        }
        return attributes;
    }

    private ColumnAttributes visitColumnAttributeList(OBParser.Opt_column_attribute_listContext context) {
        ColumnAttributes attributes = new ColumnAttributes(context);
        if (context.opt_column_attribute_list() != null) {
            attributes.merge(this.visitColumnAttributeList(context.opt_column_attribute_list()));
        }
        attributes.merge(this.visitColumnAttribute(context.column_attribute()));
        return attributes;
    }

    private ColumnAttributes visitColumnAttribute(OBParser.Column_attributeContext ctx) {
        ColumnAttributes attributes = new ColumnAttributes(ctx);
        InLineConstraint attribute = new InLineConstraint(ctx, null, null);
        if (ctx.NULLX() != null) {
            attribute.setNullable(ctx.not() == null);
            attributes.setConstraints(Collections.singletonList(attribute));
        } else if (ctx.PRIMARY() != null) {
            attribute.setPrimaryKey(true);
            attributes.setConstraints(Collections.singletonList(attribute));
        } else if (ctx.UNIQUE() != null) {
            attribute.setUniqueKey(true);
            attributes.setConstraints(Collections.singletonList(attribute));
        } else if (ctx.KEY() != null) {
            attribute.setPrimaryKey(true);
            attributes.setConstraints(Collections.singletonList(attribute));
        } else if (ctx.CHECK() != null) {
            attribute = new InLineCheckConstraint(ctx, null, null, new MySQLExpressionFactory(ctx.expr()).generate());
            attributes.setConstraints(Collections.singletonList(attribute));
        } else if (ctx.DEFAULT() != null || ctx.ORIG_DEFAULT() != null) {
            Expression expr = this.visitNowOrSignedLiteral(ctx.now_or_signed_literal());
            if (ctx.DEFAULT() != null) {
                attributes.setDefaultValue(expr);
            } else {
                attributes.setOrigDefault(expr);
            }
        } else if (ctx.AUTO_INCREMENT() != null) {
            attributes.setAutoIncrement(true);
        } else if (ctx.COMMENT() != null) {
            attributes.setComment(ctx.STRING_VALUE().getText());
        } else if (ctx.ON() != null && ctx.UPDATE() != null) {
            attributes.setOnUpdate(this.visitCurTimestampFunc(ctx.cur_timestamp_func()));
        } else if (ctx.ID() != null) {
            attributes.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        return attributes;
    }

    private Expression visitNowOrSignedLiteral(OBParser.Now_or_signed_literalContext context) {
        if (context.cur_timestamp_func() != null) {
            return this.visitCurTimestampFunc(context.cur_timestamp_func());
        }
        return MySQLTableElementFactory.getSignedLiteral(context.signed_literal());
    }

    public static Expression getSignedLiteral(OBParser.Signed_literalContext context) {
        if (context == null) {
            return null;
        }
        ConstExpression constExpr = context.literal() != null ? new ConstExpression(context.literal()) : new ConstExpression(context.number_literal());
        Operator operator = null;
        if (context.Minus() != null) {
            operator = Operator.SUB;
        } else if (context.Plus() != null) {
            operator = Operator.ADD;
        }
        return operator == null ? constExpr : new CompoundExpression(context, constExpr, null, operator);
    }

    private Expression visitCurTimestampFunc(OBParser.Cur_timestamp_funcContext context) {
        String funcName = context.getChild(0).getText();
        ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
        if (context.INTNUM() != null) {
            params.add(new ExpressionParam(new ConstExpression(context.INTNUM())));
        }
        return new FunctionCall(context, funcName, params);
    }

    public static Boolean isUsingBTree(OBParser.Index_using_algorithmContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.BTREE() == null) {
            return null;
        }
        return true;
    }

    public static Boolean isUsingHash(OBParser.Index_using_algorithmContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.HASH() == null) {
            return null;
        }
        return true;
    }

    private List<SortColumn> getSortColumns(@NonNull OBParser.Sort_column_listContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        return ctx.sort_column_key().stream().map(c -> new MySQLSortColumnFactory((OBParser.Sort_column_keyContext)((Object)c)).generate()).collect(Collectors.toList());
    }
}

