/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.CharacterType;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import com.oceanbase.tools.sqlparser.statement.common.GeneralDataType;
import com.oceanbase.tools.sqlparser.statement.common.NumberType;
import com.oceanbase.tools.sqlparser.statement.common.TimestampType;
import com.oceanbase.tools.sqlparser.statement.common.oracle.IntervalType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.collections4.CollectionUtils;

public class OracleDataTypeFactory
extends OBParserBaseVisitor<DataType>
implements StatementFactory<DataType> {
    private final OBParser.Data_typeContext dataTypeContext;
    private final OBParser.Cast_data_typeContext castDataTypeContext;

    public OracleDataTypeFactory(@NonNull OBParser.Data_typeContext dataTypeContext) {
        if (dataTypeContext == null) {
            throw new NullPointerException("dataTypeContext is marked non-null but is null");
        }
        this.dataTypeContext = dataTypeContext;
        this.castDataTypeContext = null;
    }

    public OracleDataTypeFactory(@NonNull OBParser.Cast_data_typeContext castDataTypeContext) {
        if (castDataTypeContext == null) {
            throw new NullPointerException("castDataTypeContext is marked non-null but is null");
        }
        this.dataTypeContext = null;
        this.castDataTypeContext = castDataTypeContext;
    }

    @Override
    public DataType generate() {
        if (this.dataTypeContext != null) {
            return (DataType)this.visit((ParseTree)this.dataTypeContext);
        }
        return (DataType)this.visit((ParseTree)this.castDataTypeContext);
    }

    @Override
    public DataType visitData_type(OBParser.Data_typeContext ctx) {
        if (ctx.STRING_VALUE() != null) {
            return new GeneralDataType(ctx, ctx.STRING_VALUE().getText(), null);
        }
        if (ctx.character_type_i() != null) {
            CharacterType type = new CharacterType((ParserRuleContext)ctx, (CharacterType)this.visit((ParseTree)ctx.character_type_i()));
            if (ctx.charset_name() != null) {
                type.setCharset(ctx.charset_name().getText());
            }
            if (ctx.collation() != null) {
                type.setCollation(ctx.collation().collation_name().getText());
            }
            return type;
        }
        return (DataType)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public DataType visitInt_type_i(OBParser.Int_type_iContext ctx) {
        return new NumberType(ctx, ctx.getText(), null, null);
    }

    @Override
    public DataType visitFloat_type_i(OBParser.Float_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        if (ctx.data_type_precision() != null) {
            args.add(this.getPrecision(ctx.data_type_precision()));
        }
        BigDecimal first = null;
        BigDecimal second = null;
        if (!args.isEmpty()) {
            first = new BigDecimal((String)args.get(0));
            if (args.size() > 1) {
                second = new BigDecimal((String)args.get(1));
            }
        }
        return new NumberType(ctx, ctx.getChild(0).getText(), first, second);
    }

    @Override
    public DataType visitDouble_type_i(OBParser.Double_type_iContext ctx) {
        return new NumberType(ctx, ctx.getText(), null, null);
    }

    @Override
    public DataType visitNumber_type_i(OBParser.Number_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        this.visitNumberPrecision(ctx.number_precision(), args);
        BigDecimal first = null;
        BigDecimal second = null;
        boolean starPrecision = false;
        if (!args.isEmpty()) {
            if (!"*".equals(args.get(0))) {
                first = new BigDecimal((String)args.get(0));
            } else {
                starPrecision = true;
            }
            if (args.size() > 1) {
                second = new BigDecimal((String)args.get(1));
            }
        }
        NumberType numberType = new NumberType(ctx, ctx.getChild(0).getText(), first, second);
        if (starPrecision) {
            numberType.setStarPresicion(true);
        }
        return numberType;
    }

    @Override
    public DataType visitTimestamp_type_i(OBParser.Timestamp_type_iContext ctx) {
        BigDecimal precision = null;
        if (ctx.data_type_precision() != null) {
            precision = new BigDecimal(this.getPrecision(ctx.data_type_precision()));
        }
        if (ctx.WITH() == null) {
            return new TimestampType(ctx, precision, false, false);
        }
        if (ctx.LOCAL() != null) {
            return new TimestampType(ctx, precision, false, true);
        }
        return new TimestampType(ctx, precision, true, false);
    }

    @Override
    public DataType visitDatetime_type_i(OBParser.Datetime_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getText(), null);
    }

    @Override
    public DataType visitCharacter_type_i(OBParser.Character_type_iContext ctx) {
        CharacterType type;
        ArrayList<String> args = new ArrayList<String>();
        String typeName = ctx.getChild(0).getText();
        this.visitStringLengthI(ctx.string_length_i(), args);
        if (args.isEmpty()) {
            type = new CharacterType(ctx, typeName, null);
        } else {
            String[] arg = ((String)args.get(0)).split(" ");
            type = new CharacterType(ctx, typeName, new BigDecimal(arg[0]));
            if (arg.length > 1) {
                type.setLengthOption(arg[1]);
            }
        }
        if (ctx.BINARY() != null) {
            type.setBinary(true);
        }
        return type;
    }

    @Override
    public DataType visitBinary_type_i(OBParser.Binary_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        if (ctx.zero_suffix_intnum() != null) {
            args.add(ctx.zero_suffix_intnum().getText());
        }
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), args);
    }

    @Override
    public DataType visitInterval_type_i(OBParser.Interval_type_iContext ctx) {
        if (ctx.YEAR() != null) {
            BigDecimal yearPrecision = null;
            if (ctx.year_precision != null) {
                yearPrecision = new BigDecimal(this.getPrecision(ctx.year_precision));
            }
            return new IntervalType((ParserRuleContext)ctx, yearPrecision);
        }
        BigDecimal dayPrecision = null;
        BigDecimal secondPrecision = null;
        if (ctx.day_precision != null) {
            dayPrecision = new BigDecimal(this.getPrecision(ctx.day_precision));
        }
        if (ctx.second_precision != null) {
            secondPrecision = new BigDecimal(this.getPrecision(ctx.second_precision));
        }
        return new IntervalType(ctx, dayPrecision, secondPrecision);
    }

    @Override
    public DataType visitRowid_type_i(OBParser.Rowid_type_iContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        if (ctx.urowid_length_i() != null) {
            args.add(ctx.urowid_length_i().INTNUM().getText());
        }
        return new GeneralDataType(ctx, ctx.getChild(0).getText(), args);
    }

    @Override
    public DataType visitUdt_type_i(OBParser.Udt_type_iContext ctx) {
        return new GeneralDataType(ctx, ctx.getText(), null);
    }

    private void visitNumberPrecision(OBParser.Number_precisionContext ctx, List<String> args) {
        if (ctx == null) {
            return;
        }
        if (ctx.precision_decimal_num() != null) {
            args.add(ctx.precision_decimal_num().getText());
        } else {
            if (ctx.Star() != null) {
                args.add(ctx.Star().getText());
            }
            if (CollectionUtils.isNotEmpty(ctx.signed_int_num())) {
                ctx.signed_int_num().forEach(s -> args.add(s.getText()));
            }
        }
    }

    private void visitStringLengthI(OBParser.String_length_iContext ctx, List<String> args) {
        if (ctx == null) {
            return;
        }
        StringBuilder builder = new StringBuilder(ctx.zero_suffix_intnum().getText());
        if (ctx.CHARACTER() != null || ctx.CHAR() != null || ctx.BYTE() != null) {
            builder.append(" ").append(ctx.getChild(2).getText());
        }
        args.add(builder.toString());
    }

    private String getPrecision(OBParser.Data_type_precisionContext context) {
        if (context.precision_int_num() != null) {
            return context.precision_int_num().getText();
        }
        return context.precision_decimal_num().getText();
    }
}

