/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnRefFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.insert.Insert;
import com.oceanbase.tools.sqlparser.statement.insert.InsertBody;
import com.oceanbase.tools.sqlparser.statement.insert.MultiTableInsert;
import com.oceanbase.tools.sqlparser.statement.insert.SingleTableInsert;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleInsertFactory
extends OBParserBaseVisitor<Insert>
implements StatementFactory<Insert> {
    private final OBParser.Insert_stmtContext insertStmtContext;

    public OracleInsertFactory(@NonNull OBParser.Insert_stmtContext insertStmtContext) {
        if (insertStmtContext == null) {
            throw new NullPointerException("insertStmtContext is marked non-null but is null");
        }
        this.insertStmtContext = insertStmtContext;
    }

    @Override
    public Insert generate() {
        return (Insert)this.visit((ParseTree)this.insertStmtContext);
    }

    @Override
    public Insert visitInsert_stmt(OBParser.Insert_stmtContext ctx) {
        if (ctx.single_table_insert() != null) {
            OBParser.Single_table_insertContext single = ctx.single_table_insert();
            InsertBody body = new InsertBody(single);
            if (single.column_list() != null) {
                body.setColumns(single.column_list().column_definition_ref().stream().map(c -> {
                    OracleColumnRefFactory factory = new OracleColumnRefFactory((OBParser.Column_definition_refContext)((Object)c));
                    return (ColumnReference)factory.generate();
                }).collect(Collectors.toList()));
            }
            return new SingleTableInsert((ParserRuleContext)ctx, body);
        }
        if (ctx.multi_table_insert() != null) {
            List<InsertBody> insertBodies;
            OBParser.Multi_table_insertContext multi = ctx.multi_table_insert();
            if (multi.insert_table_clause_list() != null) {
                insertBodies = this.visitInsertTableClauseList(multi.insert_table_clause_list());
            } else {
                OBParser.Conditional_insert_clauseContext c2 = multi.conditional_insert_clause();
                insertBodies = c2.condition_insert_clause_list().condition_insert_clause().stream().flatMap(i -> this.visitInsertTableClauseList(i.insert_table_clause_list()).stream()).collect(Collectors.toList());
                if (c2.insert_table_clause_list() != null) {
                    insertBodies.addAll(this.visitInsertTableClauseList(c2.insert_table_clause_list()));
                }
            }
            return new MultiTableInsert((ParserRuleContext)ctx, insertBodies);
        }
        throw new IllegalStateException("Missing insert body statement");
    }

    public List<InsertBody> visitInsertTableClauseList(OBParser.Insert_table_clause_listContext ctx) {
        return ctx.insert_single_table_clause().stream().map(this::visitInsertSingleTableClause).collect(Collectors.toList());
    }

    public InsertBody visitInsertSingleTableClause(OBParser.Insert_single_table_clauseContext ctx) {
        InsertBody insertBody = new InsertBody(ctx);
        if (ctx.column_list() != null) {
            insertBody.setColumns(ctx.column_list().column_definition_ref().stream().map(c -> {
                OracleColumnRefFactory factory = new OracleColumnRefFactory((OBParser.Column_definition_refContext)((Object)c));
                return (ColumnReference)factory.generate();
            }).collect(Collectors.toList()));
        }
        return insertBody;
    }
}

