/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement;

import com.oceanbase.tools.sqlparser.statement.Statement;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class BaseStatement
implements Statement {
    private final ParserRuleContext ruleNode;
    private final TerminalNode terminalNode;

    protected BaseStatement() {
        this(null, null);
    }

    protected BaseStatement(TerminalNode terminalNode) {
        this(null, terminalNode);
    }

    protected BaseStatement(ParserRuleContext ruleNode) {
        this(ruleNode, null);
    }

    protected BaseStatement(ParserRuleContext ruleNode, TerminalNode terminalNode) {
        this.ruleNode = ruleNode;
        this.terminalNode = terminalNode;
    }

    @Override
    public String getText() {
        if (this.ruleNode != null) {
            Token start = this.ruleNode.getStart();
            Token offset = this.ruleNode.getStop();
            if (start == null || offset == null) {
                return null;
            }
            CharStream charStream = start.getTokenSource().getInputStream();
            if (charStream == null) {
                return null;
            }
            return charStream.getText(Interval.of((int)start.getStartIndex(), (int)offset.getStopIndex()));
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getText();
        }
        return null;
    }

    @Override
    public int getStart() {
        if (this.ruleNode != null) {
            return this.ruleNode.getStart().getStartIndex();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getStartIndex();
        }
        return -1;
    }

    @Override
    public int getStop() {
        if (this.ruleNode != null) {
            return this.ruleNode.getStop().getStopIndex();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getStopIndex();
        }
        return -1;
    }

    @Override
    public int getLine() {
        if (this.ruleNode != null) {
            Token offset = this.ruleNode.getStart();
            if (offset == null) {
                return -1;
            }
            return offset.getLine();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getLine();
        }
        return -1;
    }

    @Override
    public int getCharPositionInLine() {
        if (this.ruleNode != null) {
            Token offset = this.ruleNode.getStart();
            if (offset == null) {
                return -1;
            }
            return offset.getCharPositionInLine();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getCharPositionInLine();
        }
        return -1;
    }
}

