/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.alter.table;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.alter.table.AlterTableAction;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class AlterTable
extends BaseStatement {
    private String userVariable;
    private String schema;
    private final String tableName;
    private final List<AlterTableAction> alterTableActions;

    public AlterTable(@NonNull ParserRuleContext context, @NonNull String tableName, List<AlterTableAction> alterTableActions) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
        this.alterTableActions = alterTableActions;
    }

    public AlterTable(@NonNull String tableName, List<AlterTableAction> alterTableActions) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
        this.alterTableActions = alterTableActions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE");
        if (this.schema != null) {
            builder.append(" ").append(this.schema).append(".").append(this.tableName);
        } else if (this.tableName != null) {
            builder.append(" ").append(this.tableName);
        }
        if (this.userVariable != null) {
            builder.append(this.userVariable);
        }
        if (CollectionUtils.isNotEmpty(this.alterTableActions)) {
            builder.append(" ").append(this.alterTableActions.stream().map(AlterTableAction::toString).collect(Collectors.joining(",")));
        }
        return builder.toString();
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<AlterTableAction> getAlterTableActions() {
        return this.alterTableActions;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlterTable)) {
            return false;
        }
        AlterTable other = (AlterTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        if (this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<AlterTableAction> this$alterTableActions = this.getAlterTableActions();
        List<AlterTableAction> other$alterTableActions = other.getAlterTableActions();
        return !(this$alterTableActions == null ? other$alterTableActions != null : !((Object)this$alterTableActions).equals(other$alterTableActions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlterTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<AlterTableAction> $alterTableActions = this.getAlterTableActions();
        result = result * 59 + ($alterTableActions == null ? 43 : ((Object)$alterTableActions).hashCode());
        return result;
    }
}

