/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class GeneralDataType
extends BaseStatement
implements DataType {
    private final String name;
    private final List<String> args;

    public GeneralDataType(@NonNull ParserRuleContext context, @NonNull String name, List<String> args) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.args = args == null ? Collections.emptyList() : args;
    }

    public GeneralDataType(@NonNull String name, List<String> args) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.args = args == null ? Collections.emptyList() : args;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getArguments() {
        return this.args;
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.args)) {
            return this.name;
        }
        return this.name + "(" + String.join((CharSequence)",", this.args) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralDataType)) {
            return false;
        }
        GeneralDataType other = (GeneralDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$args = this.args;
        List<String> other$args = other.args;
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $args = this.args;
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }
}

