/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineForeignConstraint;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ColumnAttributes
extends BaseOptions {
    private Expression defaultValue;
    private Expression origDefault;
    private Boolean autoIncrement;
    private Integer id;
    private String comment;
    private Expression onUpdate;
    private List<InLineConstraint> constraints;

    public ColumnAttributes(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    @Override
    protected void doMerge(PropertyDescriptor pd, Object otherVal) throws InvocationTargetException, IllegalAccessException {
        if (!"constraints".equals(pd.getName()) || this.constraints == null) {
            super.doMerge(pd, otherVal);
        } else {
            this.constraints = new ArrayList<InLineConstraint>(this.constraints);
            this.constraints.addAll((List)otherVal);
        }
    }

    public List<InLineCheckConstraint> getCheckConstraints() {
        if (CollectionUtils.isEmpty(this.constraints)) {
            return Collections.emptyList();
        }
        return this.constraints.stream().filter(c -> c instanceof InLineCheckConstraint).map(c -> (InLineCheckConstraint)c).collect(Collectors.toList());
    }

    public List<InLineForeignConstraint> getForeignConstraints() {
        if (CollectionUtils.isEmpty(this.constraints)) {
            return Collections.emptyList();
        }
        return this.constraints.stream().filter(c -> c instanceof InLineForeignConstraint).map(c -> (InLineForeignConstraint)c).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (Boolean.TRUE.equals(this.autoIncrement)) {
            builder.append(" AUTO_INCREMENT");
        }
        if (this.defaultValue != null) {
            builder.append(" DEFAULT ").append(this.defaultValue);
        }
        if (this.origDefault != null) {
            builder.append(" ORIG_DEFAULT ").append(this.origDefault);
        }
        if (this.id != null) {
            builder.append(" ID ").append(this.id);
        }
        if (this.comment != null) {
            builder.append(" COMMENT ").append(this.comment);
        }
        if (this.onUpdate != null) {
            builder.append(" ON UPDATE ").append(this.onUpdate);
        }
        if (CollectionUtils.isNotEmpty(this.constraints)) {
            builder.append(" ").append(this.constraints.stream().map(InLineConstraint::toString).collect(Collectors.joining(" ")));
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public Expression getOrigDefault() {
        return this.origDefault;
    }

    public Boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public Integer getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public Expression getOnUpdate() {
        return this.onUpdate;
    }

    public List<InLineConstraint> getConstraints() {
        return this.constraints;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setOrigDefault(Expression origDefault) {
        this.origDefault = origDefault;
    }

    public void setAutoIncrement(Boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOnUpdate(Expression onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setConstraints(List<InLineConstraint> constraints) {
        this.constraints = constraints;
    }

    public ColumnAttributes() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnAttributes)) {
            return false;
        }
        ColumnAttributes other = (ColumnAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$defaultValue = this.getDefaultValue();
        Expression other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Expression this$origDefault = this.getOrigDefault();
        Expression other$origDefault = other.getOrigDefault();
        if (this$origDefault == null ? other$origDefault != null : !this$origDefault.equals(other$origDefault)) {
            return false;
        }
        Boolean this$autoIncrement = this.getAutoIncrement();
        Boolean other$autoIncrement = other.getAutoIncrement();
        if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Expression this$onUpdate = this.getOnUpdate();
        Expression other$onUpdate = other.getOnUpdate();
        if (this$onUpdate == null ? other$onUpdate != null : !this$onUpdate.equals(other$onUpdate)) {
            return false;
        }
        List<InLineConstraint> this$constraints = this.getConstraints();
        List<InLineConstraint> other$constraints = other.getConstraints();
        return !(this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Expression $origDefault = this.getOrigDefault();
        result = result * 59 + ($origDefault == null ? 43 : $origDefault.hashCode());
        Boolean $autoIncrement = this.getAutoIncrement();
        result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Expression $onUpdate = this.getOnUpdate();
        result = result * 59 + ($onUpdate == null ? 43 : $onUpdate.hashCode());
        List<InLineConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        return result;
    }
}

