/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ForeignReference
extends BaseStatement {
    private OnOption deleteOption;
    private OnOption updateOption;
    private MatchOption matchOption;
    private String userVariable;
    private final List<ColumnReference> columns;
    private final String schema;
    private final String relation;

    public ForeignReference(@NonNull ParserRuleContext context, String schema, @NonNull String relation, List<ColumnReference> columns) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.columns = columns;
        this.relation = relation;
        this.schema = schema;
    }

    public ForeignReference(String schema, @NonNull String relation, List<ColumnReference> columns) {
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.columns = columns;
        this.relation = relation;
        this.schema = schema;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("REFERENCES");
        builder.append(" ").append(this.schema == null ? "" : this.schema).append(this.schema == null ? "" : ".").append(this.relation);
        if (this.userVariable != null) {
            builder.append(this.userVariable);
        }
        if (CollectionUtils.isNotEmpty(this.columns)) {
            builder.append("(").append(this.columns.stream().map(ColumnReference::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.matchOption != null) {
            builder.append(" MATCH ").append(this.matchOption.name());
        }
        if (this.deleteOption != null) {
            builder.append(" ON DELETE ");
            builder.append(this.deleteOption.name().replace("_", " "));
        }
        if (this.updateOption != null) {
            builder.append(" ON UPDATE ");
            builder.append(this.updateOption.name().replace("_", " "));
        }
        return builder.toString();
    }

    public OnOption getDeleteOption() {
        return this.deleteOption;
    }

    public OnOption getUpdateOption() {
        return this.updateOption;
    }

    public MatchOption getMatchOption() {
        return this.matchOption;
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    public List<ColumnReference> getColumns() {
        return this.columns;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setDeleteOption(OnOption deleteOption) {
        this.deleteOption = deleteOption;
    }

    public void setUpdateOption(OnOption updateOption) {
        this.updateOption = updateOption;
    }

    public void setMatchOption(MatchOption matchOption) {
        this.matchOption = matchOption;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForeignReference)) {
            return false;
        }
        ForeignReference other = (ForeignReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OnOption this$deleteOption = this.getDeleteOption();
        OnOption other$deleteOption = other.getDeleteOption();
        if (this$deleteOption == null ? other$deleteOption != null : !((Object)((Object)this$deleteOption)).equals((Object)other$deleteOption)) {
            return false;
        }
        OnOption this$updateOption = this.getUpdateOption();
        OnOption other$updateOption = other.getUpdateOption();
        if (this$updateOption == null ? other$updateOption != null : !((Object)((Object)this$updateOption)).equals((Object)other$updateOption)) {
            return false;
        }
        MatchOption this$matchOption = this.getMatchOption();
        MatchOption other$matchOption = other.getMatchOption();
        if (this$matchOption == null ? other$matchOption != null : !((Object)((Object)this$matchOption)).equals((Object)other$matchOption)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        if (this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable)) {
            return false;
        }
        List<ColumnReference> this$columns = this.getColumns();
        List<ColumnReference> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        return !(this$relation == null ? other$relation != null : !this$relation.equals(other$relation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForeignReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OnOption $deleteOption = this.getDeleteOption();
        result = result * 59 + ($deleteOption == null ? 43 : ((Object)((Object)$deleteOption)).hashCode());
        OnOption $updateOption = this.getUpdateOption();
        result = result * 59 + ($updateOption == null ? 43 : ((Object)((Object)$updateOption)).hashCode());
        MatchOption $matchOption = this.getMatchOption();
        result = result * 59 + ($matchOption == null ? 43 : ((Object)((Object)$matchOption)).hashCode());
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        List<ColumnReference> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        return result;
    }

    public static enum MatchOption {
        SIMPLE,
        FULL,
        PARTIAL;

    }

    public static enum OnOption {
        CASCADE,
        SET_NULL,
        RESTRICT,
        NO_ACTION,
        SET_DEFAULT;

    }
}

