/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class InLineConstraint
extends BaseStatement {
    private boolean uniqueKey;
    private boolean primaryKey;
    private Boolean nullable;
    private final String constraintName;
    private final ConstraintState state;

    public InLineConstraint(@NonNull ParserRuleContext context, String constraintName, ConstraintState state) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.state = state;
        this.constraintName = constraintName;
    }

    public InLineConstraint(String constraintName, ConstraintState state) {
        this.state = state;
        this.constraintName = constraintName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.constraintName != null) {
            builder.append(" CONSTRAINT ").append(this.constraintName);
        }
        if (this.isPrimaryKey()) {
            builder.append(" PRIMARY KEY");
            return builder.substring(1);
        }
        if (this.isUniqueKey()) {
            builder.append(" UNIQUE");
            return builder.substring(1);
        }
        if (this.nullable != null) {
            if (this.nullable.booleanValue()) {
                builder.append(" NULL");
            } else {
                builder.append(" NOT NULL");
            }
        }
        if (this.state != null) {
            builder.append(" ").append(this.state.toString());
        }
        return builder.length() >= 1 ? builder.substring(1) : "";
    }

    public boolean isUniqueKey() {
        return this.uniqueKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public ConstraintState getState() {
        return this.state;
    }

    public void setUniqueKey(boolean uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InLineConstraint)) {
            return false;
        }
        InLineConstraint other = (InLineConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUniqueKey() != other.isUniqueKey()) {
            return false;
        }
        if (this.isPrimaryKey() != other.isPrimaryKey()) {
            return false;
        }
        Boolean this$nullable = this.getNullable();
        Boolean other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !((Object)this$nullable).equals(other$nullable)) {
            return false;
        }
        String this$constraintName = this.getConstraintName();
        String other$constraintName = other.getConstraintName();
        if (this$constraintName == null ? other$constraintName != null : !this$constraintName.equals(other$constraintName)) {
            return false;
        }
        ConstraintState this$state = this.getState();
        ConstraintState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InLineConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUniqueKey() ? 79 : 97);
        result = result * 59 + (this.isPrimaryKey() ? 79 : 97);
        Boolean $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : ((Object)$nullable).hashCode());
        String $constraintName = this.getConstraintName();
        result = result * 59 + ($constraintName == null ? 43 : $constraintName.hashCode());
        ConstraintState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        return result;
    }
}

