/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class IndexOptions
extends BaseOptions {
    private Integer virtualColumnId;
    private Integer blockSize;
    private Integer dataTableId;
    private Integer indexTableId;
    private Boolean global;
    private Integer maxUsedPartId;
    private String comment;
    private Boolean withRowId;
    private String withParser;
    private Boolean usingBtree;
    private Boolean usingHash;
    private Boolean visible;
    private Integer parallel;
    private Boolean noParallel;
    private Integer pctFree;
    private Integer pctUsed;
    private Integer iniTrans;
    private Integer maxTrans;
    private List<String> storage;
    private String tableSpace;
    private Boolean reverse;
    private List<ColumnReference> storing;
    private List<ColumnReference> ctxcat;

    public IndexOptions(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public IndexOptions(@NonNull TerminalNode terminalNode) {
        super(terminalNode);
        if (terminalNode == null) {
            throw new NullPointerException("terminalNode is marked non-null but is null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (Boolean.TRUE.equals(this.usingBtree)) {
            builder.append(" USING BTREE");
        }
        if (Boolean.TRUE.equals(this.usingHash)) {
            builder.append(" USING HASH");
        }
        if (this.global != null) {
            builder.append(" ").append(this.global != false ? "GLOBAL" : "LOCAL");
        }
        if (this.blockSize != null) {
            builder.append(" ").append("BLOCK_SIZE=").append(this.blockSize);
        }
        if (this.dataTableId != null) {
            builder.append(" ").append("DATA_TABLE_ID=").append(this.dataTableId);
        }
        if (this.indexTableId != null) {
            builder.append(" ").append("INDEX_TABLE_ID=").append(this.indexTableId);
        }
        if (this.virtualColumnId != null) {
            builder.append(" ").append("VIRTUAL_COLUMN_ID=").append(this.virtualColumnId);
        }
        if (this.maxUsedPartId != null) {
            builder.append(" ").append("MAX_USED_PART_ID=").append(this.maxUsedPartId);
        }
        if (this.comment != null) {
            builder.append(" ").append("COMMENT ").append(this.comment);
        }
        if (this.storing != null) {
            builder.append(" ").append("STORING(").append(this.storing.stream().map(ColumnReference::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.ctxcat != null) {
            builder.append(" ").append("CTXCAT(").append(this.ctxcat.stream().map(ColumnReference::toString).collect(Collectors.joining(","))).append(")");
        }
        if (Boolean.TRUE.equals(this.withRowId)) {
            builder.append(" WITH ROWID");
        }
        if (this.withParser != null) {
            builder.append(" WITH PARSER ").append(this.withParser);
        }
        if (this.visible != null) {
            builder.append(" ").append(this.visible != false ? "VISIBLE" : "INVISIBLE");
        }
        if (this.parallel != null) {
            builder.append(" PARALLEL=").append(this.parallel);
        }
        if (Boolean.TRUE.equals(this.noParallel)) {
            builder.append(" NOPARALLEL");
        }
        if (Boolean.TRUE.equals(this.reverse)) {
            builder.append(" REVERSE");
        }
        if (this.pctFree != null) {
            builder.append(" PCTFREE=").append(this.pctFree);
        }
        if (this.pctUsed != null) {
            builder.append(" PCTUSED ").append(this.pctUsed);
        }
        if (this.iniTrans != null) {
            builder.append(" INITRANS ").append(this.iniTrans);
        }
        if (this.maxTrans != null) {
            builder.append(" MAXTRANS ").append(this.maxTrans);
        }
        if (this.storage != null) {
            builder.append(" STORAGE(").append(String.join((CharSequence)" ", this.storage)).append(")");
        }
        if (this.tableSpace != null) {
            builder.append(" TABLESPACE ").append(this.tableSpace);
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public Integer getVirtualColumnId() {
        return this.virtualColumnId;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getDataTableId() {
        return this.dataTableId;
    }

    public Integer getIndexTableId() {
        return this.indexTableId;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public Integer getMaxUsedPartId() {
        return this.maxUsedPartId;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean getWithRowId() {
        return this.withRowId;
    }

    public String getWithParser() {
        return this.withParser;
    }

    public Boolean getUsingBtree() {
        return this.usingBtree;
    }

    public Boolean getUsingHash() {
        return this.usingHash;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public Integer getParallel() {
        return this.parallel;
    }

    public Boolean getNoParallel() {
        return this.noParallel;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public Integer getPctUsed() {
        return this.pctUsed;
    }

    public Integer getIniTrans() {
        return this.iniTrans;
    }

    public Integer getMaxTrans() {
        return this.maxTrans;
    }

    public List<String> getStorage() {
        return this.storage;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public List<ColumnReference> getStoring() {
        return this.storing;
    }

    public List<ColumnReference> getCtxcat() {
        return this.ctxcat;
    }

    public void setVirtualColumnId(Integer virtualColumnId) {
        this.virtualColumnId = virtualColumnId;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public void setDataTableId(Integer dataTableId) {
        this.dataTableId = dataTableId;
    }

    public void setIndexTableId(Integer indexTableId) {
        this.indexTableId = indexTableId;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public void setMaxUsedPartId(Integer maxUsedPartId) {
        this.maxUsedPartId = maxUsedPartId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setWithRowId(Boolean withRowId) {
        this.withRowId = withRowId;
    }

    public void setWithParser(String withParser) {
        this.withParser = withParser;
    }

    public void setUsingBtree(Boolean usingBtree) {
        this.usingBtree = usingBtree;
    }

    public void setUsingHash(Boolean usingHash) {
        this.usingHash = usingHash;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public void setParallel(Integer parallel) {
        this.parallel = parallel;
    }

    public void setNoParallel(Boolean noParallel) {
        this.noParallel = noParallel;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public void setPctUsed(Integer pctUsed) {
        this.pctUsed = pctUsed;
    }

    public void setIniTrans(Integer iniTrans) {
        this.iniTrans = iniTrans;
    }

    public void setMaxTrans(Integer maxTrans) {
        this.maxTrans = maxTrans;
    }

    public void setStorage(List<String> storage) {
        this.storage = storage;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public void setStoring(List<ColumnReference> storing) {
        this.storing = storing;
    }

    public void setCtxcat(List<ColumnReference> ctxcat) {
        this.ctxcat = ctxcat;
    }

    public IndexOptions() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexOptions)) {
            return false;
        }
        IndexOptions other = (IndexOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$virtualColumnId = this.getVirtualColumnId();
        Integer other$virtualColumnId = other.getVirtualColumnId();
        if (this$virtualColumnId == null ? other$virtualColumnId != null : !((Object)this$virtualColumnId).equals(other$virtualColumnId)) {
            return false;
        }
        Integer this$blockSize = this.getBlockSize();
        Integer other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !((Object)this$blockSize).equals(other$blockSize)) {
            return false;
        }
        Integer this$dataTableId = this.getDataTableId();
        Integer other$dataTableId = other.getDataTableId();
        if (this$dataTableId == null ? other$dataTableId != null : !((Object)this$dataTableId).equals(other$dataTableId)) {
            return false;
        }
        Integer this$indexTableId = this.getIndexTableId();
        Integer other$indexTableId = other.getIndexTableId();
        if (this$indexTableId == null ? other$indexTableId != null : !((Object)this$indexTableId).equals(other$indexTableId)) {
            return false;
        }
        Boolean this$global = this.getGlobal();
        Boolean other$global = other.getGlobal();
        if (this$global == null ? other$global != null : !((Object)this$global).equals(other$global)) {
            return false;
        }
        Integer this$maxUsedPartId = this.getMaxUsedPartId();
        Integer other$maxUsedPartId = other.getMaxUsedPartId();
        if (this$maxUsedPartId == null ? other$maxUsedPartId != null : !((Object)this$maxUsedPartId).equals(other$maxUsedPartId)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Boolean this$withRowId = this.getWithRowId();
        Boolean other$withRowId = other.getWithRowId();
        if (this$withRowId == null ? other$withRowId != null : !((Object)this$withRowId).equals(other$withRowId)) {
            return false;
        }
        String this$withParser = this.getWithParser();
        String other$withParser = other.getWithParser();
        if (this$withParser == null ? other$withParser != null : !this$withParser.equals(other$withParser)) {
            return false;
        }
        Boolean this$usingBtree = this.getUsingBtree();
        Boolean other$usingBtree = other.getUsingBtree();
        if (this$usingBtree == null ? other$usingBtree != null : !((Object)this$usingBtree).equals(other$usingBtree)) {
            return false;
        }
        Boolean this$usingHash = this.getUsingHash();
        Boolean other$usingHash = other.getUsingHash();
        if (this$usingHash == null ? other$usingHash != null : !((Object)this$usingHash).equals(other$usingHash)) {
            return false;
        }
        Boolean this$visible = this.getVisible();
        Boolean other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !((Object)this$visible).equals(other$visible)) {
            return false;
        }
        Integer this$parallel = this.getParallel();
        Integer other$parallel = other.getParallel();
        if (this$parallel == null ? other$parallel != null : !((Object)this$parallel).equals(other$parallel)) {
            return false;
        }
        Boolean this$noParallel = this.getNoParallel();
        Boolean other$noParallel = other.getNoParallel();
        if (this$noParallel == null ? other$noParallel != null : !((Object)this$noParallel).equals(other$noParallel)) {
            return false;
        }
        Integer this$pctFree = this.getPctFree();
        Integer other$pctFree = other.getPctFree();
        if (this$pctFree == null ? other$pctFree != null : !((Object)this$pctFree).equals(other$pctFree)) {
            return false;
        }
        Integer this$pctUsed = this.getPctUsed();
        Integer other$pctUsed = other.getPctUsed();
        if (this$pctUsed == null ? other$pctUsed != null : !((Object)this$pctUsed).equals(other$pctUsed)) {
            return false;
        }
        Integer this$iniTrans = this.getIniTrans();
        Integer other$iniTrans = other.getIniTrans();
        if (this$iniTrans == null ? other$iniTrans != null : !((Object)this$iniTrans).equals(other$iniTrans)) {
            return false;
        }
        Integer this$maxTrans = this.getMaxTrans();
        Integer other$maxTrans = other.getMaxTrans();
        if (this$maxTrans == null ? other$maxTrans != null : !((Object)this$maxTrans).equals(other$maxTrans)) {
            return false;
        }
        List<String> this$storage = this.getStorage();
        List<String> other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        String this$tableSpace = this.getTableSpace();
        String other$tableSpace = other.getTableSpace();
        if (this$tableSpace == null ? other$tableSpace != null : !this$tableSpace.equals(other$tableSpace)) {
            return false;
        }
        Boolean this$reverse = this.getReverse();
        Boolean other$reverse = other.getReverse();
        if (this$reverse == null ? other$reverse != null : !((Object)this$reverse).equals(other$reverse)) {
            return false;
        }
        List<ColumnReference> this$storing = this.getStoring();
        List<ColumnReference> other$storing = other.getStoring();
        if (this$storing == null ? other$storing != null : !((Object)this$storing).equals(other$storing)) {
            return false;
        }
        List<ColumnReference> this$ctxcat = this.getCtxcat();
        List<ColumnReference> other$ctxcat = other.getCtxcat();
        return !(this$ctxcat == null ? other$ctxcat != null : !((Object)this$ctxcat).equals(other$ctxcat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $virtualColumnId = this.getVirtualColumnId();
        result = result * 59 + ($virtualColumnId == null ? 43 : ((Object)$virtualColumnId).hashCode());
        Integer $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : ((Object)$blockSize).hashCode());
        Integer $dataTableId = this.getDataTableId();
        result = result * 59 + ($dataTableId == null ? 43 : ((Object)$dataTableId).hashCode());
        Integer $indexTableId = this.getIndexTableId();
        result = result * 59 + ($indexTableId == null ? 43 : ((Object)$indexTableId).hashCode());
        Boolean $global = this.getGlobal();
        result = result * 59 + ($global == null ? 43 : ((Object)$global).hashCode());
        Integer $maxUsedPartId = this.getMaxUsedPartId();
        result = result * 59 + ($maxUsedPartId == null ? 43 : ((Object)$maxUsedPartId).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Boolean $withRowId = this.getWithRowId();
        result = result * 59 + ($withRowId == null ? 43 : ((Object)$withRowId).hashCode());
        String $withParser = this.getWithParser();
        result = result * 59 + ($withParser == null ? 43 : $withParser.hashCode());
        Boolean $usingBtree = this.getUsingBtree();
        result = result * 59 + ($usingBtree == null ? 43 : ((Object)$usingBtree).hashCode());
        Boolean $usingHash = this.getUsingHash();
        result = result * 59 + ($usingHash == null ? 43 : ((Object)$usingHash).hashCode());
        Boolean $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : ((Object)$visible).hashCode());
        Integer $parallel = this.getParallel();
        result = result * 59 + ($parallel == null ? 43 : ((Object)$parallel).hashCode());
        Boolean $noParallel = this.getNoParallel();
        result = result * 59 + ($noParallel == null ? 43 : ((Object)$noParallel).hashCode());
        Integer $pctFree = this.getPctFree();
        result = result * 59 + ($pctFree == null ? 43 : ((Object)$pctFree).hashCode());
        Integer $pctUsed = this.getPctUsed();
        result = result * 59 + ($pctUsed == null ? 43 : ((Object)$pctUsed).hashCode());
        Integer $iniTrans = this.getIniTrans();
        result = result * 59 + ($iniTrans == null ? 43 : ((Object)$iniTrans).hashCode());
        Integer $maxTrans = this.getMaxTrans();
        result = result * 59 + ($maxTrans == null ? 43 : ((Object)$maxTrans).hashCode());
        List<String> $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        String $tableSpace = this.getTableSpace();
        result = result * 59 + ($tableSpace == null ? 43 : $tableSpace.hashCode());
        Boolean $reverse = this.getReverse();
        result = result * 59 + ($reverse == null ? 43 : ((Object)$reverse).hashCode());
        List<ColumnReference> $storing = this.getStoring();
        result = result * 59 + ($storing == null ? 43 : ((Object)$storing).hashCode());
        List<ColumnReference> $ctxcat = this.getCtxcat();
        result = result * 59 + ($ctxcat == null ? 43 : ((Object)$ctxcat).hashCode());
        return result;
    }
}

