/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class CollectionExpression
extends BaseStatement
implements Expression {
    private final List<Expression> expressionList = new ArrayList<Expression>();

    public CollectionExpression(ParserRuleContext context) {
        this(context, (List<Expression>)null);
    }

    public CollectionExpression(ParserRuleContext context, List<Expression> expressions) {
        super(context);
        if (CollectionUtils.isNotEmpty(expressions)) {
            this.expressionList.addAll(expressions);
        }
    }

    public void addExpression(@NonNull Expression expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        this.expressionList.add(expression);
    }

    public String toString() {
        return "(" + this.expressionList.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
    }

    public List<Expression> getExpressionList() {
        return this.expressionList;
    }

    public CollectionExpression() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionExpression)) {
            return false;
        }
        CollectionExpression other = (CollectionExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Expression> this$expressionList = this.getExpressionList();
        List<Expression> other$expressionList = other.getExpressionList();
        return !(this$expressionList == null ? other$expressionList != null : !((Object)this$expressionList).equals(other$expressionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Expression> $expressionList = this.getExpressionList();
        result = result * 59 + ($expressionList == null ? 43 : ((Object)$expressionList).hashCode());
        return result;
    }
}

