/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class ColumnReference
extends BaseStatement
implements Expression {
    private final String schema;
    private final String relation;
    private final String column;

    public ColumnReference(@NonNull ParserRuleContext context, String schema, String relation, @NonNull String column) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.column = column;
    }

    public ColumnReference(String schema, String relation, @NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.column = column;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.schema != null) {
            builder.append(this.schema).append(".");
        }
        if (this.relation != null) {
            builder.append(this.relation).append(".");
        }
        return builder.append(this.column).toString();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnReference)) {
            return false;
        }
        ColumnReference other = (ColumnReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }
}

