/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.Operator;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class CompoundExpression
extends BaseStatement
implements Expression {
    private final Expression left;
    private final Expression right;
    private final Operator operator;

    public CompoundExpression(@NonNull ParserRuleContext context, @NonNull Expression left, Expression right, Operator operator) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public CompoundExpression(@NonNull Expression left, Expression right, Operator operator) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public String toString() {
        if (this.right == null) {
            return this.operator.getText()[0] + " " + this.left.toString();
        }
        return this.left.toString() + " " + this.operator.getText()[0] + " " + this.right.toString();
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundExpression)) {
            return false;
        }
        CompoundExpression other = (CompoundExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$left = this.getLeft();
        Expression other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        Expression this$right = this.getRight();
        Expression other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
            return false;
        }
        Operator this$operator = this.getOperator();
        Operator other$operator = other.getOperator();
        return !(this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompoundExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        Expression $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        return result;
    }
}

