/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.Statement;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class FunctionCall
extends BaseStatement
implements Expression {
    private final String functionName;
    private final List<Statement> paramsOptions = new ArrayList<Statement>();
    private final List<FunctionParam> paramList;
    private String paramsFlag;

    public FunctionCall(@NonNull ParserRuleContext context, @NonNull String functionName, @NonNull List<FunctionParam> functionParams) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (functionParams == null) {
            throw new NullPointerException("functionParams is marked non-null but is null");
        }
        this.functionName = functionName;
        this.paramList = functionParams;
    }

    public FunctionCall(@NonNull String functionName, @NonNull List<FunctionParam> functionParams) {
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (functionParams == null) {
            throw new NullPointerException("functionParams is marked non-null but is null");
        }
        this.functionName = functionName;
        this.paramList = functionParams;
    }

    public void addParamsOption(@NonNull Statement paramsOpt) {
        if (paramsOpt == null) {
            throw new NullPointerException("paramsOpt is marked non-null but is null");
        }
        this.paramsOptions.add(paramsOpt);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.functionName);
        builder.append("(");
        if (this.paramsFlag != null) {
            builder.append(this.paramsFlag).append(" ");
        }
        builder.append(this.paramList.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        return builder.toString();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Statement> getParamsOptions() {
        return this.paramsOptions;
    }

    public List<FunctionParam> getParamList() {
        return this.paramList;
    }

    public String getParamsFlag() {
        return this.paramsFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        FunctionCall other = (FunctionCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        List<Statement> this$paramsOptions = this.getParamsOptions();
        List<Statement> other$paramsOptions = other.getParamsOptions();
        if (this$paramsOptions == null ? other$paramsOptions != null : !((Object)this$paramsOptions).equals(other$paramsOptions)) {
            return false;
        }
        List<FunctionParam> this$paramList = this.getParamList();
        List<FunctionParam> other$paramList = other.getParamList();
        if (this$paramList == null ? other$paramList != null : !((Object)this$paramList).equals(other$paramList)) {
            return false;
        }
        String this$paramsFlag = this.getParamsFlag();
        String other$paramsFlag = other.getParamsFlag();
        return !(this$paramsFlag == null ? other$paramsFlag != null : !this$paramsFlag.equals(other$paramsFlag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionCall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        List<Statement> $paramsOptions = this.getParamsOptions();
        result = result * 59 + ($paramsOptions == null ? 43 : ((Object)$paramsOptions).hashCode());
        List<FunctionParam> $paramList = this.getParamList();
        result = result * 59 + ($paramList == null ? 43 : ((Object)$paramList).hashCode());
        String $paramsFlag = this.getParamsFlag();
        result = result * 59 + ($paramsFlag == null ? 43 : $paramsFlag.hashCode());
        return result;
    }

    public void setParamsFlag(String paramsFlag) {
        this.paramsFlag = paramsFlag;
    }
}

