/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.select.WaitOption;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class ForUpdate
extends BaseStatement {
    private final List<ColumnReference> columns;
    private final BigDecimal waitNum;
    private final WaitOption waitOption;

    public ForUpdate(@NonNull ParserRuleContext context, @NonNull List<ColumnReference> columns, WaitOption waitOption, BigDecimal waitNum) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.columns = columns;
        this.waitOption = waitOption;
        this.waitNum = waitNum;
    }

    public ForUpdate(@NonNull List<ColumnReference> columns, WaitOption waitOption, BigDecimal waitNum) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.columns = columns;
        this.waitOption = waitOption;
        this.waitNum = waitNum;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FOR UPDATE");
        if (!this.columns.isEmpty()) {
            builder.append(" OF ").append(this.columns.stream().map(ColumnReference::toString).collect(Collectors.joining(",")));
        }
        if (this.waitOption != null) {
            builder.append(" ").append(this.waitOption.name().replace("_", " "));
            if (this.waitOption == WaitOption.WAIT) {
                builder.append(" ").append(this.waitNum.toString());
            }
        }
        return builder.toString();
    }

    public List<ColumnReference> getColumns() {
        return this.columns;
    }

    public BigDecimal getWaitNum() {
        return this.waitNum;
    }

    public WaitOption getWaitOption() {
        return this.waitOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForUpdate)) {
            return false;
        }
        ForUpdate other = (ForUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ColumnReference> this$columns = this.getColumns();
        List<ColumnReference> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        BigDecimal this$waitNum = this.getWaitNum();
        BigDecimal other$waitNum = other.getWaitNum();
        if (this$waitNum == null ? other$waitNum != null : !((Object)this$waitNum).equals(other$waitNum)) {
            return false;
        }
        WaitOption this$waitOption = this.getWaitOption();
        WaitOption other$waitOption = other.getWaitOption();
        return !(this$waitOption == null ? other$waitOption != null : !((Object)((Object)this$waitOption)).equals((Object)other$waitOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForUpdate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ColumnReference> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        BigDecimal $waitNum = this.getWaitNum();
        result = result * 59 + ($waitNum == null ? 43 : ((Object)$waitNum).hashCode());
        WaitOption $waitOption = this.getWaitOption();
        result = result * 59 + ($waitOption == null ? 43 : ((Object)((Object)$waitOption)).hashCode());
        return result;
    }
}

