/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.select.ForUpdate;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.RelationType;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.mysql.Limit;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Fetch;
import lombok.NonNull;

public class RelatedSelectBody {
    private final SelectBody select;
    private final RelationType relation;
    private Fetch fetch;
    private OrderBy orderBy;
    private Limit limit;
    private ForUpdate forUpdate;

    public RelatedSelectBody(@NonNull SelectBody selectBody, @NonNull RelationType relation) {
        if (selectBody == null) {
            throw new NullPointerException("selectBody is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.select = selectBody;
        this.relation = relation;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.relation.name().replace("_", " ")).append(" ").append(this.select.toString());
        if (this.orderBy != null) {
            builder.append(" ").append(this.orderBy.toString());
        }
        if (this.fetch != null) {
            builder.append(" ").append(this.fetch.toString());
        }
        if (this.limit != null) {
            builder.append(" ").append(this.limit.toString());
        }
        if (this.forUpdate != null) {
            builder.append(" ").append(this.forUpdate.toString());
        }
        return builder.toString();
    }

    public SelectBody getSelect() {
        return this.select;
    }

    public RelationType getRelation() {
        return this.relation;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public ForUpdate getForUpdate() {
        return this.forUpdate;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public void setForUpdate(ForUpdate forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelatedSelectBody)) {
            return false;
        }
        RelatedSelectBody other = (RelatedSelectBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SelectBody this$select = this.getSelect();
        SelectBody other$select = other.getSelect();
        if (this$select == null ? other$select != null : !((Object)this$select).equals(other$select)) {
            return false;
        }
        RelationType this$relation = this.getRelation();
        RelationType other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !((Object)((Object)this$relation)).equals((Object)other$relation)) {
            return false;
        }
        Fetch this$fetch = this.getFetch();
        Fetch other$fetch = other.getFetch();
        if (this$fetch == null ? other$fetch != null : !((Object)this$fetch).equals(other$fetch)) {
            return false;
        }
        OrderBy this$orderBy = this.getOrderBy();
        OrderBy other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        Limit this$limit = this.getLimit();
        Limit other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        ForUpdate this$forUpdate = this.getForUpdate();
        ForUpdate other$forUpdate = other.getForUpdate();
        return !(this$forUpdate == null ? other$forUpdate != null : !((Object)this$forUpdate).equals(other$forUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelatedSelectBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SelectBody $select = this.getSelect();
        result = result * 59 + ($select == null ? 43 : ((Object)$select).hashCode());
        RelationType $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : ((Object)((Object)$relation)).hashCode());
        Fetch $fetch = this.getFetch();
        result = result * 59 + ($fetch == null ? 43 : ((Object)$fetch).hashCode());
        OrderBy $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        Limit $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        ForUpdate $forUpdate = this.getForUpdate();
        result = result * 59 + ($forUpdate == null ? 43 : ((Object)$forUpdate).hashCode());
        return result;
    }
}

