/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.Window;
import com.oceanbase.tools.sqlparser.statement.select.ForUpdate;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.GroupBy;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import com.oceanbase.tools.sqlparser.statement.select.RelatedSelectBody;
import com.oceanbase.tools.sqlparser.statement.select.WithTable;
import com.oceanbase.tools.sqlparser.statement.select.mysql.Limit;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Fetch;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class SelectBody
extends BaseStatement
implements Expression {
    private Expression where;
    private Expression having;
    private String queryOptions;
    private Expression startWith;
    private Expression connectBy;
    private List<WithTable> with = new ArrayList<WithTable>();
    private boolean recursive;
    private List<GroupBy> groupBy = new ArrayList<GroupBy>();
    boolean withRollUp;
    private List<Window> windows = new ArrayList<Window>();
    private Fetch fetch;
    private Limit limit;
    private ForUpdate forUpdate;
    private OrderBy orderBy;
    private RelatedSelectBody relatedSelect;
    private final List<FromReference> froms;
    private final List<Projection> selectItems;

    public SelectBody(@NonNull ParserRuleContext context, @NonNull List<Projection> selectItemList, @NonNull List<FromReference> fromList) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (selectItemList == null) {
            throw new NullPointerException("selectItemList is marked non-null but is null");
        }
        if (fromList == null) {
            throw new NullPointerException("fromList is marked non-null but is null");
        }
        this.froms = fromList;
        this.selectItems = selectItemList;
    }

    public SelectBody(@NonNull ParserRuleContext context, @NonNull SelectBody other) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.where = other.where;
        this.having = other.having;
        this.queryOptions = other.queryOptions;
        this.startWith = other.startWith;
        this.connectBy = other.connectBy;
        this.with = other.with;
        this.recursive = other.recursive;
        this.groupBy = other.groupBy;
        this.withRollUp = other.withRollUp;
        this.windows = other.windows;
        this.fetch = other.fetch;
        this.limit = other.limit;
        this.orderBy = other.orderBy;
        this.relatedSelect = other.relatedSelect;
        this.froms = other.froms;
        this.selectItems = other.selectItems;
        this.forUpdate = other.forUpdate;
    }

    public SelectBody(@NonNull List<Projection> selectItemList, @NonNull List<FromReference> fromList) {
        if (selectItemList == null) {
            throw new NullPointerException("selectItemList is marked non-null but is null");
        }
        if (fromList == null) {
            throw new NullPointerException("fromList is marked non-null but is null");
        }
        this.froms = fromList;
        this.selectItems = selectItemList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.with)) {
            builder.append("WITH ");
            if (this.recursive) {
                builder.append("RECURSIVE ");
            }
            builder.append(this.with.stream().map(WithTable::toString).collect(Collectors.joining(","))).append(" ");
        }
        if (this.orderBy != null || this.fetch != null || this.limit != null || this.forUpdate != null) {
            builder.append("(");
        }
        builder.append("SELECT");
        if (this.queryOptions != null) {
            builder.append(" ").append(this.queryOptions);
        }
        builder.append(" ").append(this.selectItems.stream().map(Projection::toString).collect(Collectors.joining(",")));
        if (CollectionUtils.isNotEmpty(this.froms)) {
            builder.append(" FROM ").append(this.froms.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.where != null) {
            builder.append(" WHERE ").append(this.where.toString());
        }
        if (this.startWith != null) {
            builder.append(" START WITH ").append(this.startWith.toString());
        }
        if (this.connectBy != null) {
            builder.append(" CONNECT BY ").append(this.connectBy.toString());
        }
        if (CollectionUtils.isNotEmpty(this.groupBy)) {
            builder.append(" GROUP BY ").append(this.groupBy.stream().map(Object::toString).collect(Collectors.joining(",")));
            if (this.withRollUp) {
                builder.append(" WITH ROLLUP");
            }
        }
        if (this.having != null) {
            builder.append(" HAVING ").append(this.having.toString());
        }
        if (CollectionUtils.isNotEmpty(this.windows)) {
            builder.append(" WINDOW ").append(this.windows.stream().map(Window::toString).collect(Collectors.joining(",")));
        }
        if (this.orderBy != null) {
            builder.append(" ").append(this.orderBy.toString());
        }
        if (this.fetch != null) {
            builder.append(" ").append(this.fetch.toString());
        }
        if (this.limit != null) {
            builder.append(" ").append(this.limit.toString());
        }
        if (this.forUpdate != null) {
            builder.append(" ").append(this.forUpdate.toString());
        }
        if (this.orderBy != null || this.fetch != null || this.limit != null || this.forUpdate != null) {
            builder.append(")");
        }
        if (this.relatedSelect != null) {
            builder.append(" ").append(this.relatedSelect.toString());
        }
        return builder.toString();
    }

    public Expression getWhere() {
        return this.where;
    }

    public Expression getHaving() {
        return this.having;
    }

    public String getQueryOptions() {
        return this.queryOptions;
    }

    public Expression getStartWith() {
        return this.startWith;
    }

    public Expression getConnectBy() {
        return this.connectBy;
    }

    public List<WithTable> getWith() {
        return this.with;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public List<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public boolean isWithRollUp() {
        return this.withRollUp;
    }

    public List<Window> getWindows() {
        return this.windows;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public ForUpdate getForUpdate() {
        return this.forUpdate;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public RelatedSelectBody getRelatedSelect() {
        return this.relatedSelect;
    }

    public List<FromReference> getFroms() {
        return this.froms;
    }

    public List<Projection> getSelectItems() {
        return this.selectItems;
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public void setQueryOptions(String queryOptions) {
        this.queryOptions = queryOptions;
    }

    public void setStartWith(Expression startWith) {
        this.startWith = startWith;
    }

    public void setConnectBy(Expression connectBy) {
        this.connectBy = connectBy;
    }

    public void setWith(List<WithTable> with) {
        this.with = with;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setGroupBy(List<GroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public void setWithRollUp(boolean withRollUp) {
        this.withRollUp = withRollUp;
    }

    public void setWindows(List<Window> windows) {
        this.windows = windows;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public void setForUpdate(ForUpdate forUpdate) {
        this.forUpdate = forUpdate;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setRelatedSelect(RelatedSelectBody relatedSelect) {
        this.relatedSelect = relatedSelect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectBody)) {
            return false;
        }
        SelectBody other = (SelectBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$where = this.getWhere();
        Expression other$where = other.getWhere();
        if (this$where == null ? other$where != null : !this$where.equals(other$where)) {
            return false;
        }
        Expression this$having = this.getHaving();
        Expression other$having = other.getHaving();
        if (this$having == null ? other$having != null : !this$having.equals(other$having)) {
            return false;
        }
        String this$queryOptions = this.getQueryOptions();
        String other$queryOptions = other.getQueryOptions();
        if (this$queryOptions == null ? other$queryOptions != null : !this$queryOptions.equals(other$queryOptions)) {
            return false;
        }
        Expression this$startWith = this.getStartWith();
        Expression other$startWith = other.getStartWith();
        if (this$startWith == null ? other$startWith != null : !this$startWith.equals(other$startWith)) {
            return false;
        }
        Expression this$connectBy = this.getConnectBy();
        Expression other$connectBy = other.getConnectBy();
        if (this$connectBy == null ? other$connectBy != null : !this$connectBy.equals(other$connectBy)) {
            return false;
        }
        List<WithTable> this$with = this.getWith();
        List<WithTable> other$with = other.getWith();
        if (this$with == null ? other$with != null : !((Object)this$with).equals(other$with)) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        List<GroupBy> this$groupBy = this.getGroupBy();
        List<GroupBy> other$groupBy = other.getGroupBy();
        if (this$groupBy == null ? other$groupBy != null : !((Object)this$groupBy).equals(other$groupBy)) {
            return false;
        }
        if (this.isWithRollUp() != other.isWithRollUp()) {
            return false;
        }
        List<Window> this$windows = this.getWindows();
        List<Window> other$windows = other.getWindows();
        if (this$windows == null ? other$windows != null : !((Object)this$windows).equals(other$windows)) {
            return false;
        }
        Fetch this$fetch = this.getFetch();
        Fetch other$fetch = other.getFetch();
        if (this$fetch == null ? other$fetch != null : !((Object)this$fetch).equals(other$fetch)) {
            return false;
        }
        Limit this$limit = this.getLimit();
        Limit other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        ForUpdate this$forUpdate = this.getForUpdate();
        ForUpdate other$forUpdate = other.getForUpdate();
        if (this$forUpdate == null ? other$forUpdate != null : !((Object)this$forUpdate).equals(other$forUpdate)) {
            return false;
        }
        OrderBy this$orderBy = this.getOrderBy();
        OrderBy other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        RelatedSelectBody this$relatedSelect = this.getRelatedSelect();
        RelatedSelectBody other$relatedSelect = other.getRelatedSelect();
        if (this$relatedSelect == null ? other$relatedSelect != null : !((Object)this$relatedSelect).equals(other$relatedSelect)) {
            return false;
        }
        List<FromReference> this$froms = this.getFroms();
        List<FromReference> other$froms = other.getFroms();
        if (this$froms == null ? other$froms != null : !((Object)this$froms).equals(other$froms)) {
            return false;
        }
        List<Projection> this$selectItems = this.getSelectItems();
        List<Projection> other$selectItems = other.getSelectItems();
        return !(this$selectItems == null ? other$selectItems != null : !((Object)this$selectItems).equals(other$selectItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $where = this.getWhere();
        result = result * 59 + ($where == null ? 43 : $where.hashCode());
        Expression $having = this.getHaving();
        result = result * 59 + ($having == null ? 43 : $having.hashCode());
        String $queryOptions = this.getQueryOptions();
        result = result * 59 + ($queryOptions == null ? 43 : $queryOptions.hashCode());
        Expression $startWith = this.getStartWith();
        result = result * 59 + ($startWith == null ? 43 : $startWith.hashCode());
        Expression $connectBy = this.getConnectBy();
        result = result * 59 + ($connectBy == null ? 43 : $connectBy.hashCode());
        List<WithTable> $with = this.getWith();
        result = result * 59 + ($with == null ? 43 : ((Object)$with).hashCode());
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        List<GroupBy> $groupBy = this.getGroupBy();
        result = result * 59 + ($groupBy == null ? 43 : ((Object)$groupBy).hashCode());
        result = result * 59 + (this.isWithRollUp() ? 79 : 97);
        List<Window> $windows = this.getWindows();
        result = result * 59 + ($windows == null ? 43 : ((Object)$windows).hashCode());
        Fetch $fetch = this.getFetch();
        result = result * 59 + ($fetch == null ? 43 : ((Object)$fetch).hashCode());
        Limit $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        ForUpdate $forUpdate = this.getForUpdate();
        result = result * 59 + ($forUpdate == null ? 43 : ((Object)$forUpdate).hashCode());
        OrderBy $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        RelatedSelectBody $relatedSelect = this.getRelatedSelect();
        result = result * 59 + ($relatedSelect == null ? 43 : ((Object)$relatedSelect).hashCode());
        List<FromReference> $froms = this.getFroms();
        result = result * 59 + ($froms == null ? 43 : ((Object)$froms).hashCode());
        List<Projection> $selectItems = this.getSelectItems();
        result = result * 59 + ($selectItems == null ? 43 : ((Object)$selectItems).hashCode());
        return result;
    }
}

