/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.SortKey;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SearchMode;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SetValue;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class WithTable
extends BaseStatement {
    private final String relation;
    private final SelectBody select;
    private List<String> aliasList;
    private SearchMode searchMode;
    private List<SortKey> searchSortKeyList;
    private SetValue searchValueSet;
    private SetValue cycleValueSet;
    private List<String> cycleAliasList;

    public WithTable(@NonNull ParserRuleContext context, @NonNull String relation, @NonNull SelectBody select) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (select == null) {
            throw new NullPointerException("select is marked non-null but is null");
        }
        this.relation = relation;
        this.select = select;
    }

    public WithTable(@NonNull String relation, @NonNull SelectBody select) {
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (select == null) {
            throw new NullPointerException("select is marked non-null but is null");
        }
        this.relation = relation;
        this.select = select;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.relation);
        if (CollectionUtils.isNotEmpty(this.aliasList)) {
            builder.append(" (").append(String.join((CharSequence)",", this.aliasList)).append(")");
        }
        builder.append(" AS (").append(this.select.toString()).append(")");
        if (this.searchMode != null) {
            builder.append(" SEARCH ").append(this.searchMode.name()).append(" BY ").append(this.searchSortKeyList.stream().map(SortKey::toString).collect(Collectors.joining(","))).append(" ").append(this.searchValueSet.toString());
        }
        if (CollectionUtils.isNotEmpty(this.cycleAliasList)) {
            builder.append(" CYCLE ").append(String.join((CharSequence)",", this.cycleAliasList)).append(" ").append(this.cycleValueSet.toString());
        }
        return builder.toString();
    }

    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public void setSearchSortKeyList(List<SortKey> searchSortKeyList) {
        this.searchSortKeyList = searchSortKeyList;
    }

    public void setSearchValueSet(SetValue searchValueSet) {
        this.searchValueSet = searchValueSet;
    }

    public void setCycleValueSet(SetValue cycleValueSet) {
        this.cycleValueSet = cycleValueSet;
    }

    public void setCycleAliasList(List<String> cycleAliasList) {
        this.cycleAliasList = cycleAliasList;
    }

    public String getRelation() {
        return this.relation;
    }

    public SelectBody getSelect() {
        return this.select;
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public List<SortKey> getSearchSortKeyList() {
        return this.searchSortKeyList;
    }

    public SetValue getSearchValueSet() {
        return this.searchValueSet;
    }

    public SetValue getCycleValueSet() {
        return this.cycleValueSet;
    }

    public List<String> getCycleAliasList() {
        return this.cycleAliasList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WithTable)) {
            return false;
        }
        WithTable other = (WithTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        SelectBody this$select = this.getSelect();
        SelectBody other$select = other.getSelect();
        if (this$select == null ? other$select != null : !((Object)this$select).equals(other$select)) {
            return false;
        }
        List<String> this$aliasList = this.getAliasList();
        List<String> other$aliasList = other.getAliasList();
        if (this$aliasList == null ? other$aliasList != null : !((Object)this$aliasList).equals(other$aliasList)) {
            return false;
        }
        SearchMode this$searchMode = this.getSearchMode();
        SearchMode other$searchMode = other.getSearchMode();
        if (this$searchMode == null ? other$searchMode != null : !((Object)((Object)this$searchMode)).equals((Object)other$searchMode)) {
            return false;
        }
        List<SortKey> this$searchSortKeyList = this.getSearchSortKeyList();
        List<SortKey> other$searchSortKeyList = other.getSearchSortKeyList();
        if (this$searchSortKeyList == null ? other$searchSortKeyList != null : !((Object)this$searchSortKeyList).equals(other$searchSortKeyList)) {
            return false;
        }
        SetValue this$searchValueSet = this.getSearchValueSet();
        SetValue other$searchValueSet = other.getSearchValueSet();
        if (this$searchValueSet == null ? other$searchValueSet != null : !((Object)this$searchValueSet).equals(other$searchValueSet)) {
            return false;
        }
        SetValue this$cycleValueSet = this.getCycleValueSet();
        SetValue other$cycleValueSet = other.getCycleValueSet();
        if (this$cycleValueSet == null ? other$cycleValueSet != null : !((Object)this$cycleValueSet).equals(other$cycleValueSet)) {
            return false;
        }
        List<String> this$cycleAliasList = this.getCycleAliasList();
        List<String> other$cycleAliasList = other.getCycleAliasList();
        return !(this$cycleAliasList == null ? other$cycleAliasList != null : !((Object)this$cycleAliasList).equals(other$cycleAliasList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WithTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        SelectBody $select = this.getSelect();
        result = result * 59 + ($select == null ? 43 : ((Object)$select).hashCode());
        List<String> $aliasList = this.getAliasList();
        result = result * 59 + ($aliasList == null ? 43 : ((Object)$aliasList).hashCode());
        SearchMode $searchMode = this.getSearchMode();
        result = result * 59 + ($searchMode == null ? 43 : ((Object)((Object)$searchMode)).hashCode());
        List<SortKey> $searchSortKeyList = this.getSearchSortKeyList();
        result = result * 59 + ($searchSortKeyList == null ? 43 : ((Object)$searchSortKeyList).hashCode());
        SetValue $searchValueSet = this.getSearchValueSet();
        result = result * 59 + ($searchValueSet == null ? 43 : ((Object)$searchValueSet).hashCode());
        SetValue $cycleValueSet = this.getCycleValueSet();
        result = result * 59 + ($cycleValueSet == null ? 43 : ((Object)$cycleValueSet).hashCode());
        List<String> $cycleAliasList = this.getCycleAliasList();
        result = result * 59 + ($cycleAliasList == null ? 43 : ((Object)$cycleAliasList).hashCode());
        return result;
    }
}

