/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select.oracle;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionCall;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.lang3.StringUtils;

public class Pivot
extends BaseStatement {
    private final List<FunctionItem> functionItems;
    private final List<ColumnReference> forColumns;
    private final List<ExpressionItem> inItems;
    private String alias;

    public Pivot(@NonNull ParserRuleContext context, @NonNull List<FunctionItem> functionItems, @NonNull List<ColumnReference> forColumns, @NonNull List<ExpressionItem> inItems) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (functionItems == null) {
            throw new NullPointerException("functionItems is marked non-null but is null");
        }
        if (forColumns == null) {
            throw new NullPointerException("forColumns is marked non-null but is null");
        }
        if (inItems == null) {
            throw new NullPointerException("inItems is marked non-null but is null");
        }
        this.forColumns = forColumns;
        this.inItems = inItems;
        this.functionItems = functionItems;
    }

    public Pivot(@NonNull List<FunctionItem> functionItems, @NonNull List<ColumnReference> forColumns, @NonNull List<ExpressionItem> inItems) {
        if (functionItems == null) {
            throw new NullPointerException("functionItems is marked non-null but is null");
        }
        if (forColumns == null) {
            throw new NullPointerException("forColumns is marked non-null but is null");
        }
        if (inItems == null) {
            throw new NullPointerException("inItems is marked non-null but is null");
        }
        this.forColumns = forColumns;
        this.inItems = inItems;
        this.functionItems = functionItems;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PIVOT(");
        builder.append(this.functionItems.stream().map(FunctionItem::toString).collect(Collectors.joining(","))).append(" FOR");
        if (this.forColumns.size() == 1) {
            builder.append(" ").append(this.forColumns.get(0));
        } else {
            builder.append("(").append(this.forColumns.stream().map(ColumnReference::toString).collect(Collectors.joining(","))).append(")");
        }
        builder.append(" IN(").append(this.inItems.stream().map(ExpressionItem::toString).collect(Collectors.joining(","))).append(")").append(")");
        if (StringUtils.isNotBlank((CharSequence)this.alias)) {
            builder.append(" ").append(this.alias);
        }
        return builder.toString();
    }

    public List<FunctionItem> getFunctionItems() {
        return this.functionItems;
    }

    public List<ColumnReference> getForColumns() {
        return this.forColumns;
    }

    public List<ExpressionItem> getInItems() {
        return this.inItems;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pivot)) {
            return false;
        }
        Pivot other = (Pivot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FunctionItem> this$functionItems = this.getFunctionItems();
        List<FunctionItem> other$functionItems = other.getFunctionItems();
        if (this$functionItems == null ? other$functionItems != null : !((Object)this$functionItems).equals(other$functionItems)) {
            return false;
        }
        List<ColumnReference> this$forColumns = this.getForColumns();
        List<ColumnReference> other$forColumns = other.getForColumns();
        if (this$forColumns == null ? other$forColumns != null : !((Object)this$forColumns).equals(other$forColumns)) {
            return false;
        }
        List<ExpressionItem> this$inItems = this.getInItems();
        List<ExpressionItem> other$inItems = other.getInItems();
        if (this$inItems == null ? other$inItems != null : !((Object)this$inItems).equals(other$inItems)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pivot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FunctionItem> $functionItems = this.getFunctionItems();
        result = result * 59 + ($functionItems == null ? 43 : ((Object)$functionItems).hashCode());
        List<ColumnReference> $forColumns = this.getForColumns();
        result = result * 59 + ($forColumns == null ? 43 : ((Object)$forColumns).hashCode());
        List<ExpressionItem> $inItems = this.getInItems();
        result = result * 59 + ($inItems == null ? 43 : ((Object)$inItems).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public static class ExpressionItem
    extends BaseStatement {
        private final String alias;
        private final Expression expression;

        public ExpressionItem(@NonNull ParserRuleContext context, @NonNull Expression expression, String alias) {
            super(context);
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
            this.alias = alias;
        }

        public ExpressionItem(@NonNull Expression expression, String alias) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.alias = alias;
            this.expression = expression;
        }

        public String toString() {
            if (StringUtils.isBlank((CharSequence)this.alias)) {
                return this.expression.toString();
            }
            return this.expression.toString() + " AS " + this.alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionItem)) {
                return false;
            }
            ExpressionItem other = (ExpressionItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExpressionItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }
    }

    public static class FunctionItem
    extends BaseStatement {
        private final String alias;
        private final FunctionCall functionCall;

        public FunctionItem(@NonNull ParserRuleContext context, @NonNull FunctionCall functionCall, String alias) {
            super(context);
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            if (functionCall == null) {
                throw new NullPointerException("functionCall is marked non-null but is null");
            }
            this.functionCall = functionCall;
            this.alias = alias;
        }

        public FunctionItem(@NonNull FunctionCall functionCall, String alias) {
            if (functionCall == null) {
                throw new NullPointerException("functionCall is marked non-null but is null");
            }
            this.alias = alias;
            this.functionCall = functionCall;
        }

        public String toString() {
            if (StringUtils.isBlank((CharSequence)this.alias)) {
                return this.functionCall.toString();
            }
            return this.functionCall.toString() + " AS " + this.alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public FunctionCall getFunctionCall() {
            return this.functionCall;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionItem)) {
                return false;
            }
            FunctionItem other = (FunctionItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            FunctionCall this$functionCall = this.getFunctionCall();
            FunctionCall other$functionCall = other.getFunctionCall();
            return !(this$functionCall == null ? other$functionCall != null : !((Object)this$functionCall).equals(other$functionCall));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            FunctionCall $functionCall = this.getFunctionCall();
            result = result * 59 + ($functionCall == null ? 43 : ((Object)$functionCall).hashCode());
            return result;
        }
    }
}

