/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLPartitionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableOptionsFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLCreateTableFactory
extends OBParserBaseVisitor<CreateTable>
implements StatementFactory<CreateTable> {
    private final OBParser.Create_table_stmtContext createTableStmtContext;

    public MySQLCreateTableFactory(@NonNull OBParser.Create_table_stmtContext createTableStmtContext) {
        if (createTableStmtContext == null) {
            throw new NullPointerException("createTableStmtContext is marked non-null but is null");
        }
        this.createTableStmtContext = createTableStmtContext;
    }

    @Override
    public CreateTable generate() {
        return (CreateTable)this.visit((ParseTree)this.createTableStmtContext);
    }

    @Override
    public CreateTable visitCreate_table_stmt(OBParser.Create_table_stmtContext ctx) {
        RelationFactor factor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor());
        CreateTable createTable = new CreateTable((ParserRuleContext)ctx, factor.getRelation());
        if (ctx.temporary_option().TEMPORARY() != null) {
            createTable.setTemporary(true);
        } else if (ctx.temporary_option().EXTERNAL() != null) {
            createTable.setExternal(true);
        }
        if (ctx.IF() != null && ctx.not() != null && ctx.EXISTS() != null) {
            createTable.setIfNotExists(true);
        }
        createTable.setSchema(factor.getSchema());
        createTable.setUserVariable(factor.getUserVariable());
        if (ctx.table_element_list() != null) {
            createTable.setTableElements(ctx.table_element_list().table_element().stream().map(c -> new MySQLTableElementFactory((OBParser.Table_elementContext)((Object)c)).generate()).collect(Collectors.toList()));
        } else {
            createTable.setAs(new MySQLSelectFactory(ctx.select_stmt()).generate());
        }
        if (ctx.table_option_list() != null) {
            createTable.setTableOptions(new MySQLTableOptionsFactory(ctx.table_option_list()).generate());
        }
        if (ctx.opt_partition_option() != null) {
            createTable.setPartition(new MySQLPartitionFactory(ctx.opt_partition_option()).generate());
        }
        return createTable;
    }
}

