/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLDataTypeFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectBodyFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLWindowSpecFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.Operator;
import com.oceanbase.tools.sqlparser.statement.common.BraceBlock;
import com.oceanbase.tools.sqlparser.statement.common.CharacterType;
import com.oceanbase.tools.sqlparser.statement.common.GeneralDataType;
import com.oceanbase.tools.sqlparser.statement.common.WindowSpec;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.BoolValue;
import com.oceanbase.tools.sqlparser.statement.expression.CaseWhen;
import com.oceanbase.tools.sqlparser.statement.expression.CollectionExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.CompoundExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.expression.DefaultExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ExpressionParam;
import com.oceanbase.tools.sqlparser.statement.expression.FullTextSearch;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionCall;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import com.oceanbase.tools.sqlparser.statement.expression.GroupConcat;
import com.oceanbase.tools.sqlparser.statement.expression.IntervalExpression;
import com.oceanbase.tools.sqlparser.statement.expression.JsonOnOption;
import com.oceanbase.tools.sqlparser.statement.expression.NullExpression;
import com.oceanbase.tools.sqlparser.statement.expression.TextSearchMode;
import com.oceanbase.tools.sqlparser.statement.expression.WhenClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;

public class MySQLExpressionFactory
extends OBParserBaseVisitor<Expression>
implements StatementFactory<Expression> {
    private final ParserRuleContext parserRuleContext;

    public MySQLExpressionFactory(@NonNull OBParser.ExprContext exprContext) {
        if (exprContext == null) {
            throw new NullPointerException("exprContext is marked non-null but is null");
        }
        this.parserRuleContext = exprContext;
    }

    public MySQLExpressionFactory() {
        this.parserRuleContext = null;
    }

    public MySQLExpressionFactory(@NonNull OBParser.Bit_exprContext bitExprContext) {
        if (bitExprContext == null) {
            throw new NullPointerException("bitExprContext is marked non-null but is null");
        }
        this.parserRuleContext = bitExprContext;
    }

    public MySQLExpressionFactory(@NonNull OBParser.LiteralContext literalContext) {
        if (literalContext == null) {
            throw new NullPointerException("literalContext is marked non-null but is null");
        }
        this.parserRuleContext = literalContext;
    }

    @Override
    public Expression generate() {
        return this.visit((ParseTree)this.parserRuleContext);
    }

    public Expression visit(ParseTree tree) {
        if (tree == null) {
            return null;
        }
        return (Expression)super.visit(tree);
    }

    @Override
    public Expression visitExpr(OBParser.ExprContext ctx) {
        if (ctx.bool_pri() != null) {
            Expression left = this.visit((ParseTree)ctx.bool_pri());
            if (ctx.IS() == null) {
                return left;
            }
            Operator operator = ctx.not() == null ? Operator.EQ : Operator.NE;
            BaseExpression right = ctx.BOOL_VALUE() != null ? new BoolValue(ctx.BOOL_VALUE()) : new ConstExpression(ctx.UNKNOWN().getText());
            return new CompoundExpression(ctx, left, right, operator);
        }
        Expression left = this.visit((ParseTree)ctx.expr(0));
        if (ctx.expr().size() == 1) {
            if (ctx.NOT() != null) {
                return new CompoundExpression(ctx, left, null, Operator.NOT);
            }
            if (ctx.USER_VARIABLE() != null) {
                return new CompoundExpression(ctx, new ConstExpression(ctx.USER_VARIABLE()), left, Operator.SET_VAR);
            }
            return left;
        }
        Expression right = this.visit((ParseTree)ctx.expr(1));
        Operator operator = null;
        if (ctx.AND() != null || ctx.AND_OP() != null) {
            operator = Operator.AND;
        } else if (ctx.CNNOP() != null) {
            operator = Operator.CNNOP;
        } else if (ctx.OR() != null) {
            operator = Operator.OR;
        } else if (ctx.XOR() != null) {
            operator = Operator.XOR;
        }
        if (operator == null) {
            throw new IllegalStateException("Missing operator");
        }
        return new CompoundExpression(ctx, left, right, operator);
    }

    @Override
    public Expression visitBool_pri(OBParser.Bool_priContext ctx) {
        if (ctx.bool_pri() == null && ctx.predicate() != null) {
            return this.visit((ParseTree)ctx.predicate());
        }
        Operator operator = null;
        if (ctx.COMP_EQ() != null) {
            operator = Operator.EQ;
        } else if (ctx.COMP_GE() != null) {
            operator = Operator.GE;
        } else if (ctx.COMP_GT() != null) {
            operator = Operator.GT;
        } else if (ctx.COMP_LE() != null) {
            operator = Operator.LE;
        } else if (ctx.COMP_LT() != null) {
            operator = Operator.LT;
        } else if (ctx.COMP_NE() != null) {
            operator = Operator.NE;
        } else if (ctx.COMP_NSEQ() != null) {
            operator = Operator.NSEQ;
        } else if (ctx.IS() != null) {
            operator = Operator.EQ;
            if (ctx.not() != null) {
                operator = Operator.NE;
            }
        }
        Expression left = null;
        Expression right = null;
        if (ctx.bool_pri() != null && ctx.predicate() != null) {
            left = this.visit((ParseTree)ctx.bool_pri());
            right = this.visit((ParseTree)ctx.predicate());
        } else if (ctx.NULLX() != null) {
            left = this.visit((ParseTree)ctx.bool_pri());
            right = new NullExpression(ctx.bool_pri());
        } else if (ctx.bool_pri() != null && ctx.select_no_parens() != null) {
            left = this.visit((ParseTree)ctx.bool_pri());
            right = this.visit((ParseTree)ctx.select_no_parens());
        }
        if (left == null || right == null || operator == null) {
            throw new IllegalStateException("Unable to build expression, some syntax modules are missing");
        }
        return new CompoundExpression(ctx, left, right, operator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Expression visitPredicate(OBParser.PredicateContext ctx) {
        boolean notExist;
        List<OBParser.Bit_exprContext> bitExprList = ctx.bit_expr();
        if (CollectionUtils.isEmpty(bitExprList)) {
            throw new IllegalStateException("Missing expression");
        }
        Operator operator = null;
        boolean bl = notExist = ctx.not() != null;
        if (ctx.IN() != null) {
            operator = notExist ? Operator.NOT_IN : Operator.IN;
        } else if (ctx.BETWEEN() != null) {
            operator = notExist ? Operator.NOT_BETWEEN : Operator.BETWEEN;
        } else if (ctx.LIKE() != null) {
            operator = notExist ? Operator.NOT_LIKE : Operator.LIKE;
        } else if (ctx.REGEXP() != null) {
            operator = notExist ? Operator.NOT_REGEXP : Operator.REGEXP;
        } else if (ctx.MEMBER() != null) {
            Operator operator2 = operator = notExist ? Operator.NOT_MEMBER_OF : Operator.MEMBER_OF;
        }
        if (operator == null) {
            if (bitExprList.size() == 1) return this.visit((ParseTree)bitExprList.get(0));
            throw new IllegalStateException("Unknown error");
        }
        Expression left = this.visit((ParseTree)bitExprList.get(0));
        Expression right = null;
        if (ctx.in_expr() != null) {
            right = this.visit((ParseTree)ctx.in_expr());
        } else if (ctx.AND() != null && ctx.predicate() != null) {
            right = new CompoundExpression(ctx, this.visit((ParseTree)bitExprList.get(1)), this.visit((ParseTree)ctx.predicate()), Operator.AND);
        } else if (ctx.LIKE() != null) {
            List strValList = ctx.string_val_list().stream().map(this::visit).collect(Collectors.toList());
            List simpleExprs = ctx.simple_expr().stream().map(this::visit).collect(Collectors.toList());
            if (ctx.ESCAPE() == null) {
                if (strValList.size() == 1) {
                    right = (Expression)strValList.get(0);
                } else {
                    if (simpleExprs.size() != 1) throw new IllegalStateException("Parser error");
                    right = (Expression)simpleExprs.get(0);
                }
            } else {
                ArrayList<Integer> strValIndexes = new ArrayList<Integer>();
                ArrayList<Integer> simpleExprIndexes = new ArrayList<Integer>();
                for (int i = 0; i < ctx.getChildCount(); ++i) {
                    ParseTree parseTree = ctx.getChild(i);
                    if (parseTree instanceof OBParser.String_val_listContext) {
                        strValIndexes.add(i);
                        continue;
                    }
                    if (!(parseTree instanceof OBParser.Simple_exprContext)) continue;
                    simpleExprIndexes.add(i);
                }
                if (simpleExprs.size() == 2) {
                    right = new CompoundExpression(ctx, (Expression)simpleExprs.get(0), (Expression)simpleExprs.get(1), Operator.ESCAPE);
                } else if (strValList.size() == 2) {
                    right = new CompoundExpression(ctx, (Expression)strValList.get(0), (Expression)strValList.get(1), Operator.ESCAPE);
                } else {
                    if (strValList.size() != 1 || simpleExprs.size() != 1) throw new IllegalStateException("Missing expression");
                    Integer strValIndex = (Integer)strValIndexes.get(0);
                    Integer simpleExprIndex = (Integer)simpleExprIndexes.get(0);
                    Expression first = strValIndex < simpleExprIndex ? (Expression)strValList.get(0) : (Expression)simpleExprs.get(0);
                    Expression second = strValIndex < simpleExprIndex ? (Expression)simpleExprs.get(0) : (Expression)strValList.get(0);
                    right = new CompoundExpression(ctx, first, second, Operator.ESCAPE);
                }
            }
        } else if (ctx.REGEXP() != null) {
            if (ctx.string_val_list(0) != null) {
                right = this.visit((ParseTree)ctx.string_val_list(0));
            } else {
                if (ctx.bit_expr(1) == null) throw new IllegalStateException("Missing expression");
                right = this.visit((ParseTree)ctx.bit_expr(1));
            }
        } else if (ctx.MEMBER() != null && ctx.simple_expr(0) != null) {
            right = this.visit((ParseTree)ctx.simple_expr(0));
        }
        if (right != null) return new CompoundExpression(ctx, left, right, operator);
        throw new IllegalStateException("Unknown branch");
    }

    @Override
    public Expression visitLiteral(OBParser.LiteralContext ctx) {
        if (ctx.complex_string_literal() != null) {
            return this.visit((ParseTree)ctx.complex_string_literal());
        }
        return new ConstExpression(ctx);
    }

    @Override
    public Expression visitExpr_const(OBParser.Expr_constContext ctx) {
        if (ctx.literal() != null) {
            return this.visit((ParseTree)ctx.literal());
        }
        return new ConstExpression(ctx);
    }

    @Override
    public Expression visitSimple_expr(OBParser.Simple_exprContext ctx) {
        List<OBParser.Simple_exprContext> simpleExprContexts = ctx.simple_expr();
        if (CollectionUtils.isNotEmpty(simpleExprContexts)) {
            Expression left = this.visit((ParseTree)simpleExprContexts.get(0));
            Operator operator = null;
            if (ctx.CNNOP() != null) {
                operator = Operator.CNNOP;
            } else if (ctx.BINARY() != null) {
                operator = Operator.BINARY;
            } else if (ctx.Plus() != null) {
                operator = Operator.ADD;
            } else if (ctx.Minus() != null) {
                operator = Operator.SUB;
            } else if (ctx.Tilde() != null) {
                operator = Operator.TILDE;
            } else if (ctx.Not() != null || ctx.NOT() != null) {
                operator = Operator.NOT;
            }
            if (simpleExprContexts.size() == 1) {
                if (operator == null) {
                    return left;
                }
                return new CompoundExpression(ctx, left, null, operator);
            }
            return new CompoundExpression(ctx, left, this.visit((ParseTree)simpleExprContexts.get(1)), Operator.CNNOP);
        }
        if (ctx.column_ref() != null) {
            MySQLColumnRefFactory factory = new MySQLColumnRefFactory(ctx.column_ref());
            return (Expression)factory.generate();
        }
        if (ctx.expr_const() != null) {
            return this.visit((ParseTree)ctx.expr_const());
        }
        if (ctx.expr_list() != null) {
            if (ctx.ROW() == null) {
                return this.visit((ParseTree)ctx.expr_list());
            }
            List<FunctionParam> params = ctx.expr_list().expr().stream().map(e -> new ExpressionParam(this.visit((ParseTree)e))).collect(Collectors.toList());
            return new FunctionCall(ctx, ctx.ROW().getText(), params);
        }
        if (ctx.select_with_parens() != null) {
            MySQLSelectBodyFactory factory = new MySQLSelectBodyFactory(ctx.select_with_parens());
            if (ctx.EXISTS() == null) {
                return factory.generate();
            }
            return new CompoundExpression(ctx, factory.generate(), null, Operator.EXISTS);
        }
        if (ctx.MATCH() != null) {
            List<FunctionParam> params = ctx.column_list().column_definition_ref().stream().map(c -> {
                MySQLColumnRefFactory factory = new MySQLColumnRefFactory((OBParser.Column_definition_refContext)((Object)c));
                return new ExpressionParam((Expression)factory.generate());
            }).collect(Collectors.toList());
            TextSearchMode searchMode = null;
            if (ctx.BOOLEAN() != null) {
                searchMode = TextSearchMode.BOOLEAN_MODE;
            } else if (ctx.NATURAL() != null) {
                searchMode = TextSearchMode.NATURAL_LANGUAGE_MODE;
            }
            FullTextSearch f = new FullTextSearch((ParserRuleContext)ctx, params, ctx.STRING_VALUE().getText());
            f.setSearchMode(searchMode);
            return f;
        }
        if (ctx.func_expr() != null) {
            return this.visit((ParseTree)ctx.func_expr());
        }
        if (ctx.window_function() != null) {
            return this.visit((ParseTree)ctx.window_function());
        }
        if (ctx.USER_VARIABLE() != null) {
            if (CollectionUtils.isEmpty(ctx.relation_name())) {
                return new ConstExpression(ctx.USER_VARIABLE());
            }
            List relations = ctx.relation_name().stream().map(RuleContext::getText).collect(Collectors.toList());
            String column = (String)relations.get(relations.size() - 1);
            String relation = (String)relations.get(relations.size() - 2);
            String schema = null;
            if (relations.size() >= 3) {
                schema = (String)relations.get(relations.size() - 3);
            }
            ColumnReference ref = new ColumnReference(ctx, schema, relation, column);
            ref.setUserVariable(ctx.USER_VARIABLE().getText());
            return ref;
        }
        if (ctx.column_definition_ref() != null) {
            MySQLColumnRefFactory factory = new MySQLColumnRefFactory(ctx.column_definition_ref());
            Operator operator = ctx.JSON_EXTRACT() == null ? Operator.JSON_EXTRACT_UNQUOTED : Operator.JSON_EXTRACT;
            return new CompoundExpression(ctx, (Expression)factory.generate(), this.visit((ParseTree)ctx.complex_string_literal()), operator);
        }
        if (ctx.case_expr() != null) {
            return this.visit((ParseTree)ctx.case_expr());
        }
        if (ctx.LeftBrace() != null && ctx.RightBrace() != null) {
            return new BraceBlock(ctx, ctx.relation_name(0).getText(), this.visit((ParseTree)ctx.expr()));
        }
        return new DefaultExpression(ctx);
    }

    @Override
    public Expression visitCase_expr(OBParser.Case_exprContext ctx) {
        List<WhenClause> whenClauses = ctx.when_clause_list().when_clause().stream().map(e -> new WhenClause((ParserRuleContext)e, this.visit((ParseTree)e.expr(0)), this.visit((ParseTree)e.expr(1)))).collect(Collectors.toList());
        CaseWhen caseWhen = new CaseWhen((ParserRuleContext)ctx, whenClauses);
        if (ctx.expr() != null) {
            caseWhen.setCaseValue(this.visit((ParseTree)ctx.expr()));
        }
        if (ctx.case_default() != null) {
            caseWhen.setCaseDefault(this.visit((ParseTree)ctx.case_default().expr()));
        }
        return caseWhen;
    }

    @Override
    public Expression visitSimple_func_expr(OBParser.Simple_func_exprContext ctx) {
        String funcName;
        if (ctx.func_name != null) {
            funcName = ctx.func_name.getText();
        } else if (ctx.function_name() != null && ctx.relation_name() == null) {
            funcName = ctx.function_name().getText();
        } else if (ctx.function_name() != null && ctx.relation_name() != null) {
            funcName = ctx.relation_name().getText() + "." + ctx.function_name().getText();
        } else {
            throw new IllegalStateException("Function name is missing");
        }
        ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
        if (ctx.Star() != null) {
            params.add(new ExpressionParam(new ConstExpression(ctx.Star())));
        } else if (CollectionUtils.isNotEmpty(ctx.expr())) {
            params.addAll(ctx.expr().stream().map(this::wrap).collect(Collectors.toList()));
        } else if (ctx.expr_list() != null) {
            params.addAll(ctx.expr_list().expr().stream().map(this::wrap).collect(Collectors.toList()));
        } else if (CollectionUtils.isNotEmpty(ctx.bit_expr())) {
            params.addAll(ctx.bit_expr().stream().map(this::wrap).collect(Collectors.toList()));
        } else if (ctx.column_definition_ref() != null) {
            MySQLColumnRefFactory factory = new MySQLColumnRefFactory(ctx.column_definition_ref());
            params.add(new ExpressionParam((Expression)factory.generate()));
        } else if (ctx.expr_as_list() != null) {
            params.addAll(ctx.expr_as_list().expr_with_opt_alias().stream().map(e -> {
                if (e.column_label() == null && e.STRING_VALUE() == null) {
                    return this.wrap(e.expr());
                }
                if (e.column_label() != null) {
                    ExpressionParam p = this.wrap(e.expr());
                    p.addOption(new ConstExpression(e.column_label()));
                    return p;
                }
                ExpressionParam p = this.wrap(e.expr());
                p.addOption(new ConstExpression(e.STRING_VALUE()));
                return p;
            }).collect(Collectors.toList()));
        }
        FunctionCall fCall = new FunctionCall(ctx, funcName, params);
        fCall.addOption(this.getAggregator(ctx));
        return fCall;
    }

    @Override
    public Expression visitComplex_string_literal(OBParser.Complex_string_literalContext ctx) {
        if (ctx.string_val_list() == null) {
            return new ConstExpression(ctx);
        }
        ArrayList<Expression> exprs = new ArrayList<Expression>(ctx.string_val_list().STRING_VALUE().size());
        exprs.add(new ConstExpression(ctx.STRING_VALUE()));
        exprs.addAll(ctx.string_val_list().STRING_VALUE().stream().map(ConstExpression::new).collect(Collectors.toList()));
        return new CollectionExpression((ParserRuleContext)ctx, exprs);
    }

    @Override
    public Expression visitComplex_func_expr(OBParser.Complex_func_exprContext ctx) {
        if (ctx.GROUP_CONCAT() != null) {
            List<FunctionParam> params = ctx.expr_list().expr().stream().map(this::wrap).collect(Collectors.toList());
            GroupConcat fCall = new GroupConcat((ParserRuleContext)ctx, params);
            fCall.addOption(this.getAggregator(ctx));
            if (ctx.order_by() != null) {
                fCall.addOption(new MySQLOrderByFactory(ctx.order_by()).generate());
            }
            if (ctx.SEPARATOR() != null) {
                fCall.addOption(new ConstExpression(ctx.SEPARATOR(), ctx.STRING_VALUE()));
            }
            return fCall;
        }
        if (ctx.CAST() != null) {
            ExpressionParam p = this.wrap(ctx.expr());
            p.addOption(new MySQLDataTypeFactory(ctx.cast_data_type()).generate());
            return new FunctionCall(ctx, ctx.CAST().getText(), Collections.singletonList(p));
        }
        if (ctx.CONVERT() != null) {
            ExpressionParam p = this.wrap(ctx.expr());
            if (ctx.cast_data_type() != null) {
                p.addOption(new MySQLDataTypeFactory(ctx.cast_data_type()).generate());
            }
            if (ctx.charset_name() != null) {
                p.addOption(new ConstExpression(ctx.charset_name()));
            }
            return new FunctionCall(ctx, ctx.CONVERT().getText(), Collections.singletonList(p));
        }
        if (ctx.POSITION() != null) {
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
            params.add(new ExpressionParam(new CompoundExpression(ctx, this.visit((ParseTree)ctx.bit_expr()), this.visit((ParseTree)ctx.expr()), Operator.IN)));
            return new FunctionCall(ctx, ctx.POSITION().getText(), params);
        }
        if (ctx.substr_or_substring() != null) {
            String funcName = ctx.substr_or_substring().getText();
            List<FunctionParam> params = ctx.substr_params().expr().stream().map(this::wrap).collect(Collectors.toList());
            return new FunctionCall(ctx, funcName, params);
        }
        if (ctx.TRIM() != null) {
            ParseTree p;
            ExpressionParam param = this.wrap(ctx.parameterized_trim().expr(0));
            if (ctx.parameterized_trim().expr(1) != null) {
                param.addOption(this.visit((ParseTree)ctx.parameterized_trim().expr(1)));
            }
            FunctionCall fCall = new FunctionCall(ctx, ctx.TRIM().getText(), Collections.singletonList(param));
            OBParser.Parameterized_trimContext trim = ctx.parameterized_trim();
            for (int i = 0; i < trim.getChildCount() && (p = trim.getChild(i)) instanceof TerminalNode; ++i) {
                fCall.addOption(new ConstExpression((TerminalNode)p));
            }
            return fCall;
        }
        if (ctx.GET_FORMAT() != null) {
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
            params.add(new ExpressionParam(new ConstExpression(ctx.get_format_unit())));
            params.add(new ExpressionParam(this.visit((ParseTree)ctx.expr())));
            return new FunctionCall(ctx, ctx.GET_FORMAT().getText(), params);
        }
        if (ctx.DATE_ADD() != null || ctx.DATE_SUB() != null || ctx.ADDDATE() != null || ctx.SUBDATE() != null) {
            String funcName = ctx.DATE_ADD() != null ? ctx.DATE_ADD().getText() : (ctx.DATE_SUB() != null ? ctx.DATE_SUB().getText() : (ctx.ADDDATE() != null ? ctx.ADDDATE().getText() : ctx.SUBDATE().getText()));
            OBParser.Date_paramsContext p = ctx.date_params();
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
            params.add(this.wrap(p.expr(0)));
            params.add(new ExpressionParam(new IntervalExpression(p, this.visit((ParseTree)p.expr(1)), p.date_unit().getText())));
            return new FunctionCall(ctx, funcName, params);
        }
        if (ctx.TIMESTAMPDIFF() != null || ctx.TIMESTAMPADD() != null) {
            String funcName = ctx.TIMESTAMPDIFF() != null ? ctx.TIMESTAMPDIFF().getText() : ctx.TIMESTAMPADD().getText();
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
            params.add(new ExpressionParam(new ConstExpression(ctx.timestamp_params().date_unit())));
            params.addAll(ctx.timestamp_params().expr().stream().map(this::wrap).collect(Collectors.toList()));
            return new FunctionCall(ctx, funcName, params);
        }
        if (ctx.EXTRACT() != null) {
            ExpressionParam p = new ExpressionParam(new ConstExpression(ctx.date_unit()));
            p.addOption(this.visit((ParseTree)ctx.expr()));
            return new FunctionCall(ctx, ctx.EXTRACT().getText(), Collections.singletonList(p));
        }
        if (ctx.CHARACTER() != null && ctx.WEIGHT_STRING() == null) {
            List<FunctionParam> params = ctx.expr_list().expr().stream().map(this::wrap).collect(Collectors.toList());
            FunctionCall f = new FunctionCall(ctx, ctx.CHARACTER().getText(), params);
            f.addOption(new ConstExpression(ctx.USING(), (ParserRuleContext)ctx.charset_name()));
            return f;
        }
        if (ctx.WEIGHT_STRING() != null) {
            String funcName = ctx.WEIGHT_STRING().getText();
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
            params.add(new ExpressionParam(this.visit((ParseTree)ctx.expr())));
            params.addAll(ctx.INTNUM().stream().map(t -> new ExpressionParam(new ConstExpression((TerminalNode)t))).collect(Collectors.toList()));
            FunctionCall fCall = new FunctionCall(ctx, funcName, params);
            if (ctx.ws_nweights() == null) {
                return fCall;
            }
            FunctionParam p1 = (FunctionParam)params.get(params.size() - 1);
            OBParser.Ws_nweightsContext weights = ctx.ws_nweights();
            String arg = weights.INTNUM().getText();
            if (ctx.CHARACTER() != null) {
                p1.addOption(new CharacterType(weights, ctx.CHARACTER().getText(), new BigDecimal(arg)));
            } else if (ctx.BINARY() != null) {
                p1.addOption(new GeneralDataType(weights, ctx.BINARY().getText(), Collections.singletonList(arg)));
            }
            return fCall;
        }
        if (ctx.json_value_expr() != null) {
            OBParser.Json_value_exprContext jsonValue = ctx.json_value_expr();
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
            params.add(new ExpressionParam(this.visit((ParseTree)jsonValue.simple_expr())));
            params.add(new ExpressionParam(this.visit((ParseTree)jsonValue.complex_string_literal())));
            FunctionCall fCall = new FunctionCall(ctx, jsonValue.JSON_VALUE().getText(), params);
            if (jsonValue.cast_data_type() != null) {
                fCall.addOption(new MySQLDataTypeFactory(jsonValue.cast_data_type()).generate());
            }
            if (jsonValue.TRUNCATE() != null) {
                fCall.addOption(new ConstExpression(jsonValue.TRUNCATE()));
            }
            if (jsonValue.ASCII() != null) {
                fCall.addOption(new ConstExpression(jsonValue.ASCII()));
            }
            if (jsonValue.on_empty() != null && jsonValue.on_error() != null) {
                JsonOnOption jsonOnOption = new JsonOnOption((ParserRuleContext)jsonValue.on_empty(), (ParserRuleContext)jsonValue.on_error());
                this.setOnError(jsonOnOption, jsonValue.on_error());
                this.setOnEmpty(jsonOnOption, jsonValue.on_empty());
                fCall.addOption(jsonOnOption);
            } else if (jsonValue.on_error() != null) {
                JsonOnOption jsonOnOption = new JsonOnOption(jsonValue.on_error());
                this.setOnError(jsonOnOption, jsonValue.on_error());
                fCall.addOption(jsonOnOption);
            } else if (jsonValue.on_empty() != null) {
                JsonOnOption jsonOnOption = new JsonOnOption(jsonValue.on_empty());
                this.setOnEmpty(jsonOnOption, jsonValue.on_empty());
                fCall.addOption(jsonOnOption);
            }
            return fCall;
        }
        String funcName = null;
        List<FunctionParam> params = new ArrayList<FunctionParam>();
        if (ctx.cur_timestamp_func() != null) {
            OBParser.Cur_timestamp_funcContext curTime = ctx.cur_timestamp_func();
            if (curTime.INTNUM() != null) {
                params.add(new ExpressionParam(new ConstExpression(curTime.INTNUM())));
            }
            funcName = curTime.NOW() == null ? curTime.now_synonyms_func().getText() : curTime.NOW().getText();
        } else if (ctx.sysdate_func() != null) {
            OBParser.Sysdate_funcContext sysdate = ctx.sysdate_func();
            if (sysdate.INTNUM() != null) {
                params.add(new ExpressionParam(new ConstExpression(sysdate.INTNUM())));
            }
            funcName = sysdate.SYSDATE().getText();
        } else if (ctx.cur_time_func() != null) {
            OBParser.Cur_time_funcContext curTime = ctx.cur_time_func();
            if (curTime.INTNUM() != null) {
                params.add(new ExpressionParam(new ConstExpression(curTime.INTNUM())));
            }
            funcName = curTime.CURTIME() == null ? curTime.CURRENT_TIME().getText() : curTime.CURTIME().getText();
        } else if (ctx.cur_date_func() != null) {
            OBParser.Cur_date_funcContext curTime = ctx.cur_date_func();
            funcName = curTime.CURDATE() == null ? curTime.CURRENT_DATE().getText() : curTime.CURDATE().getText();
        } else if (ctx.utc_timestamp_func() != null) {
            OBParser.Utc_timestamp_funcContext utcdate = ctx.utc_timestamp_func();
            if (utcdate.INTNUM() != null) {
                params.add(new ExpressionParam(new ConstExpression(utcdate.INTNUM())));
            }
            funcName = utcdate.UTC_TIMESTAMP().getText();
        } else if (ctx.utc_time_func() != null) {
            OBParser.Utc_time_funcContext utctime = ctx.utc_time_func();
            if (utctime.INTNUM() != null) {
                params.add(new ExpressionParam(new ConstExpression(utctime.INTNUM())));
            }
            funcName = utctime.UTC_TIME().getText();
        } else if (ctx.utc_date_func() != null) {
            funcName = ctx.utc_date_func().UTC_DATE().getText();
        } else if (ctx.sys_interval_func() != null) {
            params = ctx.sys_interval_func().expr().stream().map(this::wrap).collect(Collectors.toList());
            if (ctx.sys_interval_func().INTERVAL() != null) {
                funcName = ctx.sys_interval_func().INTERVAL().getText();
            } else if (ctx.sys_interval_func().CHECK() != null) {
                funcName = ctx.sys_interval_func().CHECK().getText();
            }
        }
        if (funcName == null) {
            throw new IllegalStateException("Missing function name");
        }
        return new FunctionCall(ctx, funcName, params);
    }

    @Override
    public Expression visitWindow_function(OBParser.Window_functionContext ctx) {
        if (ctx.func_name == null) {
            throw new IllegalStateException("Missing function name");
        }
        String funcName = ctx.func_name.getText();
        ArrayList<BaseStatement> functionOpts = new ArrayList<BaseStatement>();
        MySQLWindowSpecFactory factory = new MySQLWindowSpecFactory(ctx.new_generalized_window_clause());
        WindowSpec window = (WindowSpec)factory.generate();
        if (ctx.ALL() != null) {
            functionOpts.add(new ConstExpression(ctx.ALL()));
        } else if (ctx.DISTINCT() != null) {
            functionOpts.add(new ConstExpression(ctx.DISTINCT()));
        } else if (ctx.UNIQUE() != null) {
            functionOpts.add(new ConstExpression(ctx.UNIQUE()));
        }
        ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
        if (ctx.Star() != null) {
            params.add(new ExpressionParam(new ConstExpression(ctx.Star())));
        } else if (CollectionUtils.isNotEmpty(ctx.expr())) {
            params.addAll(ctx.expr().stream().map(e -> new ExpressionParam(this.visit((ParseTree)e))).collect(Collectors.toList()));
        } else if (ctx.expr_list() != null) {
            params.addAll(ctx.expr_list().expr().stream().map(e -> new ExpressionParam(this.visit((ParseTree)e))).collect(Collectors.toList()));
        } else if (CollectionUtils.isNotEmpty(ctx.bit_expr())) {
            params.addAll(ctx.bit_expr().stream().map(e -> new ExpressionParam(this.visit((ParseTree)e))).collect(Collectors.toList()));
        } else if (ctx.win_fun_first_last_params() != null) {
            OBParser.Win_fun_first_last_paramsContext c = ctx.win_fun_first_last_params();
            params.add(new ExpressionParam(this.visit((ParseTree)c.expr())));
            if (c.respect_or_ignore() != null) {
                functionOpts.add(new ConstExpression((ParserRuleContext)c.respect_or_ignore(), c.NULLS()));
            }
        }
        if (ctx.NTH_VALUE() != null) {
            if (ctx.first_or_last() != null) {
                functionOpts.add(new ConstExpression(ctx.FROM(), (ParserRuleContext)ctx.first_or_last()));
            }
            if (ctx.respect_or_ignore() != null) {
                functionOpts.add(new ConstExpression((ParserRuleContext)ctx.respect_or_ignore(), ctx.NULLS()));
            }
        }
        if (ctx.GROUP_CONCAT() != null || ctx.LISTAGG() != null) {
            if (ctx.order_by() != null) {
                functionOpts.add(new MySQLOrderByFactory(ctx.order_by()).generate());
            }
            if (ctx.SEPARATOR() != null) {
                functionOpts.add(new ConstExpression(ctx.SEPARATOR(), ctx.STRING_VALUE()));
            }
            if (ctx.GROUP_CONCAT() != null) {
                GroupConcat groupConcat = new GroupConcat((ParserRuleContext)ctx, params);
                groupConcat.setWindow(window);
                functionOpts.forEach(groupConcat::addOption);
                return groupConcat;
            }
        }
        FunctionCall fCall = new FunctionCall(ctx, funcName, params);
        fCall.setWindow(window);
        functionOpts.forEach(fCall::addOption);
        return fCall;
    }

    @Override
    public Expression visitString_val_list(OBParser.String_val_listContext c) {
        List<Expression> exprs = c.STRING_VALUE().stream().map(ConstExpression::new).collect(Collectors.toList());
        return new CollectionExpression((ParserRuleContext)c, exprs);
    }

    @Override
    public Expression visitIn_expr(OBParser.In_exprContext ctx) {
        if (ctx.select_with_parens() != null) {
            return new MySQLSelectBodyFactory(ctx.select_with_parens()).generate();
        }
        return this.visit((ParseTree)ctx.expr_list());
    }

    @Override
    public Expression visitExpr_list(OBParser.Expr_listContext ctx) {
        List<Expression> expressions = ctx.expr().stream().map(this::visit).collect(Collectors.toList());
        return new CollectionExpression((ParserRuleContext)ctx, expressions);
    }

    @Override
    public Expression visitSelect_no_parens(OBParser.Select_no_parensContext ctx) {
        return new MySQLSelectBodyFactory(ctx).generate();
    }

    @Override
    public Expression visitBit_expr(OBParser.Bit_exprContext ctx) {
        if (ctx.simple_expr() != null) {
            return this.visit((ParseTree)ctx.simple_expr());
        }
        Expression left = this.visit((ParseTree)ctx.bit_expr(0));
        Expression right = null;
        Operator operator = null;
        if (ctx.And() != null) {
            operator = Operator.AND;
        } else if (ctx.Caret() != null) {
            operator = Operator.NOT;
        } else if (ctx.DIV() != null || ctx.Div() != null) {
            operator = Operator.DIV;
        } else if (ctx.MOD() != null || ctx.Mod() != null) {
            operator = Operator.MOD;
        } else if (ctx.Minus() != null) {
            operator = Operator.SUB;
        } else if (ctx.Or() != null) {
            operator = Operator.OR;
        } else if (ctx.Plus() != null) {
            operator = Operator.ADD;
        } else if (ctx.SHIFT_LEFT() != null) {
            operator = Operator.SHIFT_LEFT;
        } else if (ctx.SHIFT_RIGHT() != null) {
            operator = Operator.SHIFT_RIGHT;
        } else if (ctx.Star() != null) {
            operator = Operator.MUL;
        }
        if (operator == null) {
            throw new IllegalStateException("Missing operator");
        }
        if (ctx.bit_expr().size() == 2) {
            right = this.visit((ParseTree)ctx.bit_expr(1));
        } else if (ctx.expr() != null) {
            right = new IntervalExpression(ctx, this.visit((ParseTree)ctx.expr()), ctx.date_unit().getText());
            ParseTree firstNode = ctx.getChild(0);
            if (firstNode instanceof TerminalNode && ((TerminalNode)firstNode).getSymbol().getType() == 109) {
                return new CompoundExpression(ctx, right, left, operator);
            }
            return new CompoundExpression(ctx, left, right, operator);
        }
        if (right == null) {
            throw new IllegalStateException("Missing expression");
        }
        return new CompoundExpression(ctx, left, right, operator);
    }

    @Override
    public Expression visitJson_on_response(OBParser.Json_on_responseContext ctx) {
        if (ctx.ERROR_P() != null) {
            return new ConstExpression(ctx.ERROR_P());
        }
        if (ctx.NULLX() != null) {
            return new NullExpression(ctx.NULLX());
        }
        return MySQLTableElementFactory.getSignedLiteral(ctx.signed_literal());
    }

    @Override
    public Expression visitJson_table_expr(OBParser.Json_table_exprContext ctx) {
        FunctionCall fCall = new FunctionCall(ctx, ctx.JSON_TABLE().getText(), Arrays.asList(new ExpressionParam(this.visit((ParseTree)ctx.simple_expr())), new ExpressionParam(this.visit((ParseTree)ctx.literal()))));
        fCall.addOption(this.getJsonOnOption(ctx.mock_jt_on_error_on_empty()));
        ctx.jt_column_list().json_table_column_def().forEach(c -> fCall.addOption(this.visitJsonTableColumnDef((OBParser.Json_table_column_defContext)((Object)c))));
        return fCall;
    }

    private JsonOnOption getJsonOnOption(OBParser.Mock_jt_on_error_on_emptyContext ctx) {
        return null;
    }

    private JsonOnOption getJsonOnOption(OBParser.Opt_value_on_empty_or_error_or_mismatchContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.opt_on_empty_or_error().empty() != null) {
            return null;
        }
        JsonOnOption jsonOnOption = new JsonOnOption(ctx);
        this.setOnEmpty(jsonOnOption, ctx.opt_on_empty_or_error().on_empty());
        this.setOnError(jsonOnOption, ctx.opt_on_empty_or_error().on_error());
        return jsonOnOption;
    }

    private void setOnEmpty(JsonOnOption jsonOnOption, OBParser.On_emptyContext ctx) {
        if (ctx == null) {
            return;
        }
        jsonOnOption.setOnEmpty(this.visit((ParseTree)ctx.json_on_response()));
    }

    private void setOnError(JsonOnOption jsonOnOption, OBParser.On_errorContext ctx) {
        if (ctx == null) {
            return;
        }
        jsonOnOption.setOnError(this.visit((ParseTree)ctx.json_on_response()));
    }

    private FunctionParam visitJsonTableColumnDef(OBParser.Json_table_column_defContext ctx) {
        if (ctx.json_table_ordinality_column_def() != null) {
            return this.visitJsonTableOrdinalityColumnDef(ctx.json_table_ordinality_column_def());
        }
        if (ctx.json_table_exists_column_def() != null) {
            return this.visitJsonTableExistsColumnDef(ctx.json_table_exists_column_def());
        }
        if (ctx.json_table_value_column_def() != null) {
            return this.visitJsonTableValueColumnDef(ctx.json_table_value_column_def());
        }
        return this.visitJsonTableNestedColumnDef(ctx.json_table_nested_column_def());
    }

    private FunctionParam visitJsonTableOrdinalityColumnDef(OBParser.Json_table_ordinality_column_defContext ctx) {
        ExpressionParam param = new ExpressionParam(new ColumnReference(ctx.column_name(), null, null, ctx.column_name().getText()));
        param.addOption(new ConstExpression(ctx.FOR(), ctx.ORDINALITY()));
        return param;
    }

    private FunctionParam visitJsonTableExistsColumnDef(OBParser.Json_table_exists_column_defContext ctx) {
        ExpressionParam param = new ExpressionParam(new ColumnReference(ctx.column_name(), null, null, ctx.column_name().getText()));
        param.addOption(new MySQLDataTypeFactory(ctx.data_type()).generate());
        if (ctx.collation() != null) {
            param.addOption(new ConstExpression(ctx.collation().collation_name()));
        }
        param.addOption(new ConstExpression(ctx.EXISTS()));
        param.addOption(this.visit((ParseTree)ctx.literal()));
        param.addOption(this.getJsonOnOption(ctx.mock_jt_on_error_on_empty()));
        return param;
    }

    private FunctionParam visitJsonTableValueColumnDef(OBParser.Json_table_value_column_defContext ctx) {
        ExpressionParam param = new ExpressionParam(new ColumnReference(ctx.column_name(), null, null, ctx.column_name().getText()));
        param.addOption(new MySQLDataTypeFactory(ctx.data_type()).generate());
        if (ctx.collation() != null) {
            param.addOption(new ConstExpression(ctx.collation().collation_name()));
        }
        param.addOption(this.visit((ParseTree)ctx.literal()));
        param.addOption(this.getJsonOnOption(ctx.opt_value_on_empty_or_error_or_mismatch()));
        return param;
    }

    private FunctionParam visitJsonTableNestedColumnDef(OBParser.Json_table_nested_column_defContext ctx) {
        ExpressionParam param = ctx.PATH() == null ? new ExpressionParam(new ConstExpression(ctx.NESTED())) : new ExpressionParam(new ConstExpression(ctx.NESTED(), ctx.PATH()));
        param.addOption(this.visit((ParseTree)ctx.literal()));
        ctx.jt_column_list().json_table_column_def().forEach(c -> param.addOption(this.visitJsonTableColumnDef((OBParser.Json_table_column_defContext)((Object)c))));
        return param;
    }

    private ConstExpression getAggregator(OBParser.Simple_func_exprContext ctx) {
        if (ctx.ALL() != null) {
            return new ConstExpression(ctx.ALL());
        }
        if (ctx.DISTINCT() != null) {
            return new ConstExpression(ctx.DISTINCT());
        }
        if (ctx.UNIQUE() != null) {
            return new ConstExpression(ctx.UNIQUE());
        }
        return null;
    }

    private ExpressionParam wrap(ParserRuleContext expr) {
        return new ExpressionParam(this.visit((ParseTree)expr));
    }

    private ConstExpression getAggregator(OBParser.Complex_func_exprContext ctx) {
        if (ctx.DISTINCT() != null) {
            return new ConstExpression(ctx.DISTINCT());
        }
        if (ctx.UNIQUE() != null) {
            return new ConstExpression(ctx.UNIQUE());
        }
        return null;
    }
}

