/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLLimitFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectBodyFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.mysql.Limit;
import com.oceanbase.tools.sqlparser.statement.update.Update;
import com.oceanbase.tools.sqlparser.statement.update.UpdateAssign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLUpdateFactory
extends OBParserBaseVisitor<Update>
implements StatementFactory<Update> {
    private final OBParser.Update_stmtContext updateStmtContext;

    public MySQLUpdateFactory(@NonNull OBParser.Update_stmtContext updateStmtContext) {
        if (updateStmtContext == null) {
            throw new NullPointerException("updateStmtContext is marked non-null but is null");
        }
        this.updateStmtContext = updateStmtContext;
    }

    @Override
    public Update generate() {
        return (Update)this.visit((ParseTree)this.updateStmtContext);
    }

    @Override
    public Update visitUpdate_stmt(OBParser.Update_stmtContext updateCtx) {
        OBParserBaseVisitor factory;
        OBParser.Update_basic_stmtContext ctx = updateCtx.update_basic_stmt();
        Update update = new Update(ctx, MySQLSelectBodyFactory.visitFromList(ctx.table_references()), this.visitUpdateAsgnList(ctx.update_asgn_list()));
        if (ctx.expr() != null) {
            factory = new MySQLExpressionFactory(ctx.expr());
            update.setCursor(false);
            update.setWhere((Expression)factory.generate());
        }
        if (ctx.order_by() != null) {
            factory = new MySQLOrderByFactory(ctx.order_by());
            update.setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.limit_clause() != null) {
            factory = new MySQLLimitFactory(ctx.limit_clause());
            update.setLimit((Limit)factory.generate());
        }
        return update;
    }

    private List<UpdateAssign> visitUpdateAsgnList(OBParser.Update_asgn_listContext ctx) {
        ArrayList<UpdateAssign> returnVal = new ArrayList<UpdateAssign>();
        for (OBParser.Update_asgn_factorContext updateAsgnFactor : ctx.update_asgn_factor()) {
            MySQLColumnRefFactory columnRefFactory = new MySQLColumnRefFactory(updateAsgnFactor.column_definition_ref());
            List<ColumnReference> columnList = Arrays.asList(columnRefFactory.generate());
            OBParser.Expr_or_defaultContext exprOrDefault = updateAsgnFactor.expr_or_default();
            Expression expression = null;
            if (exprOrDefault.expr() != null) {
                MySQLExpressionFactory factory = new MySQLExpressionFactory(exprOrDefault.expr());
                expression = factory.generate();
            }
            UpdateAssign updateAssign = new UpdateAssign(updateAsgnFactor, columnList, expression, exprOrDefault.DEFAULT() != null);
            returnVal.add(updateAssign);
        }
        return returnVal;
    }
}

