/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Fetch;
import com.oceanbase.tools.sqlparser.statement.select.oracle.FetchAddition;
import com.oceanbase.tools.sqlparser.statement.select.oracle.FetchDirection;
import com.oceanbase.tools.sqlparser.statement.select.oracle.FetchType;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleFetchFactory
extends OBParserBaseVisitor<Fetch>
implements StatementFactory<Fetch> {
    private final OBParser.Fetch_nextContext fetchNextContext;
    private final OBParser.Fetch_next_clauseContext fetchNextClauseContext;

    public OracleFetchFactory(@NonNull OBParser.Fetch_nextContext fetchNextContext) {
        if (fetchNextContext == null) {
            throw new NullPointerException("fetchNextContext is marked non-null but is null");
        }
        this.fetchNextClauseContext = null;
        this.fetchNextContext = fetchNextContext;
    }

    public OracleFetchFactory(@NonNull OBParser.Fetch_next_clauseContext fetchNextClauseContext) {
        if (fetchNextClauseContext == null) {
            throw new NullPointerException("fetchNextClauseContext is marked non-null but is null");
        }
        this.fetchNextContext = null;
        this.fetchNextClauseContext = fetchNextClauseContext;
    }

    @Override
    public Fetch generate() {
        if (this.fetchNextClauseContext != null) {
            return (Fetch)this.visit((ParseTree)this.fetchNextClauseContext);
        }
        if (this.fetchNextContext == null) {
            throw new IllegalStateException("No fetch next context available");
        }
        return this.visitFetchNext(this.fetchNextContext, null);
    }

    @Override
    public Fetch visitFetch_next_clause(OBParser.Fetch_next_clauseContext ctx) {
        if (ctx.OFFSET() == null) {
            return this.visitFetchNext(ctx.fetch_next(), ctx);
        }
        if (ctx.fetch_next() != null) {
            return this.visitFetchNext(ctx.fetch_next(), ctx);
        }
        OracleExpressionFactory factory = new OracleExpressionFactory(ctx.bit_expr());
        return new Fetch(ctx, null, null, null, null, factory.generate());
    }

    private Fetch visitFetchNext(OBParser.Fetch_nextContext ctx, OBParser.Fetch_next_clauseContext parent) {
        if (ctx.fetch_next_count() != null) {
            return this.visitFetchNextCount(ctx.fetch_next_count(), parent);
        }
        return this.visitFetchNextPercent(ctx.fetch_next_percent(), parent);
    }

    private Fetch visitFetchNextCount(OBParser.Fetch_next_countContext ctx, OBParser.Fetch_next_clauseContext parent) {
        OracleExpressionFactory factory;
        FetchAddition only = ctx.ONLY() == null ? FetchAddition.WITH_TIES : FetchAddition.ONLY;
        OBParser.Fetch_next_exprContext fetchNextExprContext = ctx.fetch_next_expr();
        FetchDirection direction = fetchNextExprContext.FIRST() == null ? FetchDirection.NEXT : FetchDirection.FIRST;
        Expression fetch = null;
        if (fetchNextExprContext.bit_expr() != null) {
            factory = new OracleExpressionFactory(fetchNextExprContext.bit_expr());
            fetch = factory.generate();
        }
        if (parent == null || parent.bit_expr() == null) {
            return new Fetch(ctx, fetch, direction, FetchType.COUNT, only, null);
        }
        factory = new OracleExpressionFactory(parent.bit_expr());
        return new Fetch(parent, fetch, direction, FetchType.COUNT, only, factory.generate());
    }

    private Fetch visitFetchNextPercent(OBParser.Fetch_next_percentContext ctx, OBParser.Fetch_next_clauseContext parent) {
        OracleExpressionFactory factory;
        FetchAddition only = ctx.ONLY() == null ? FetchAddition.WITH_TIES : FetchAddition.ONLY;
        OBParser.Fetch_next_percent_exprContext fetchNextPercentExpr = ctx.fetch_next_percent_expr();
        FetchDirection direction = fetchNextPercentExpr.FIRST() == null ? FetchDirection.NEXT : FetchDirection.FIRST;
        Expression fetch = null;
        if (fetchNextPercentExpr.bit_expr() != null) {
            factory = new OracleExpressionFactory(fetchNextPercentExpr.bit_expr());
            fetch = factory.generate();
        }
        if (parent == null || parent.bit_expr() == null) {
            return new Fetch(ctx, fetch, direction, FetchType.PERCENT, only, null);
        }
        factory = new OracleExpressionFactory(parent.bit_expr());
        return new Fetch(parent, fetch, direction, FetchType.PERCENT, only, factory.generate());
    }
}

