/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import lombok.NonNull;

public class OracleProjectionFactory
extends OBParserBaseVisitor<Projection>
implements StatementFactory<Projection> {
    private final OBParser.ProjectionContext projectionContext;

    public OracleProjectionFactory(@NonNull OBParser.ProjectionContext projectionContext) {
        if (projectionContext == null) {
            throw new NullPointerException("projectionContext is marked non-null but is null");
        }
        this.projectionContext = projectionContext;
    }

    @Override
    public Projection generate() {
        return this.visitProjection(this.projectionContext);
    }

    @Override
    public Projection visitProjection(OBParser.ProjectionContext ctx) {
        if (ctx.Star() != null) {
            return new Projection(ctx.Star());
        }
        OracleExpressionFactory factory = new OracleExpressionFactory(ctx.bit_expr());
        String columnLabel = ctx.column_label() == null ? null : ctx.column_label().getText();
        return new Projection(ctx, factory.generate(), columnLabel);
    }
}

