/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleForUpdateFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSelectBodyFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.select.ForUpdate;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Fetch;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleSelectFactory
extends OBParserBaseVisitor<Select>
implements StatementFactory<Select> {
    private final OBParser.Select_stmtContext selectStmtContext;

    public OracleSelectFactory(@NonNull OBParser.Select_stmtContext selectStmtContext) {
        if (selectStmtContext == null) {
            throw new NullPointerException("selectStmtContext is marked non-null but is null");
        }
        this.selectStmtContext = selectStmtContext;
    }

    @Override
    public Select generate() {
        return (Select)this.visit((ParseTree)this.selectStmtContext);
    }

    @Override
    public Select visitSelect_stmt(OBParser.Select_stmtContext ctx) {
        OBParserBaseVisitor factory;
        OracleSelectBodyFactory selectBodyFactory = new OracleSelectBodyFactory(ctx.subquery());
        Select select = new Select((ParserRuleContext)ctx, (SelectBody)selectBodyFactory.generate());
        if (ctx.fetch_next_clause() != null) {
            factory = new OracleFetchFactory(ctx.fetch_next_clause());
            select.setFetch((Fetch)factory.generate());
        }
        if (ctx.fetch_next() != null) {
            factory = new OracleFetchFactory(ctx.fetch_next());
            select.setFetch((Fetch)factory.generate());
        }
        if (ctx.for_update() != null) {
            factory = new OracleForUpdateFactory(ctx.for_update());
            select.setForUpdate((ForUpdate)factory.generate());
        }
        if (ctx.order_by() != null) {
            factory = new OracleOrderByFactory(ctx.order_by());
            select.setOrderBy((OrderBy)factory.generate());
        }
        return select;
    }
}

