/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OraclePartitonUsageFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSelectBodyFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.select.ExpressionReference;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.NameReference;
import com.oceanbase.tools.sqlparser.statement.select.PartitionUsage;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.update.Update;
import com.oceanbase.tools.sqlparser.statement.update.UpdateAssign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleUpdateFactory
extends OBParserBaseVisitor<Update>
implements StatementFactory<Update> {
    private final OBParser.Update_stmtContext updateStmtContext;

    public OracleUpdateFactory(@NonNull OBParser.Update_stmtContext updateStmtContext) {
        if (updateStmtContext == null) {
            throw new NullPointerException("updateStmtContext is marked non-null but is null");
        }
        this.updateStmtContext = updateStmtContext;
    }

    @Override
    public Update generate() {
        return (Update)this.visit((ParseTree)this.updateStmtContext);
    }

    @Override
    public Update visitUpdate_stmt(OBParser.Update_stmtContext ctx) {
        Update update = new Update(ctx, Arrays.asList(this.visitDmlTableClauseContext(ctx.dml_table_clause())), this.visitUpdateAsgnList(ctx.update_asgn_list()));
        OBParser.Opt_where_extensionContext whereExtension = ctx.opt_where_extension();
        if (whereExtension.opt_where() == null) {
            OracleExpressionFactory factory = new OracleExpressionFactory(whereExtension.obj_access_ref());
            update.setCursor(true);
            update.setWhere((Expression)factory.generate());
        } else if (whereExtension.opt_where().expr() != null) {
            OracleExpressionFactory factory = new OracleExpressionFactory(whereExtension.opt_where().expr());
            update.setCursor(false);
            update.setWhere((Expression)factory.generate());
        }
        return update;
    }

    private FromReference visitDmlTableClauseContext(OBParser.Dml_table_clauseContext ctx) {
        String alias = null;
        if (ctx.relation_name() != null) {
            alias = ctx.relation_name().getText();
        }
        if (ctx.dml_table_name() != null) {
            OBParser.Dml_table_nameContext dmlTableName = ctx.dml_table_name();
            OBParser.Relation_factorContext r = dmlTableName.relation_factor();
            PartitionUsage partitionUsage = null;
            if (dmlTableName.use_partition() != null) {
                OraclePartitonUsageFactory factory = new OraclePartitonUsageFactory(dmlTableName.use_partition());
                partitionUsage = factory.generate();
            }
            NameReference nameReference = new NameReference(ctx, OracleFromReferenceFactory.getSchemaName(r), OracleFromReferenceFactory.getRelation(r), alias);
            if (partitionUsage != null) {
                nameReference.setPartitionUsage(partitionUsage);
            }
            nameReference.setUserVariable(OracleFromReferenceFactory.getUserVariable(r));
            return nameReference;
        }
        if (ctx.select_with_parens() != null) {
            OracleSelectBodyFactory factory = new OracleSelectBodyFactory(ctx.select_with_parens());
            SelectBody selectBody = factory.generate();
            return new ExpressionReference(ctx, selectBody, alias);
        }
        OracleSelectBodyFactory factory = new OracleSelectBodyFactory(ctx.subquery());
        SelectBody select = factory.generate();
        OBParser.Order_by_fetch_with_check_optionContext oCtx = ctx.order_by_fetch_with_check_option();
        if (oCtx.with_check_option() != null) {
            select.setWithCheckOption(true);
        }
        if (oCtx.order_by() != null) {
            select.setOrderBy(new OracleOrderByFactory(oCtx.order_by()).generate());
        }
        if (oCtx.fetch_next_clause() != null) {
            select.setFetch(new OracleFetchFactory(oCtx.fetch_next_clause()).generate());
        }
        return new ExpressionReference(ctx, select, alias);
    }

    private List<UpdateAssign> visitUpdateAsgnList(OBParser.Update_asgn_listContext ctx) {
        ArrayList<UpdateAssign> returnVal = new ArrayList<UpdateAssign>();
        if (ctx.normal_asgn_list() == null) {
            return returnVal;
        }
        OBParser.Normal_asgn_listContext normalAsgnList = ctx.normal_asgn_list();
        for (OBParser.Update_asgn_factorContext updateAsgnFactor : normalAsgnList.update_asgn_factor()) {
            OBParserBaseVisitor factory;
            List<ColumnReference> columnList = new ArrayList<ColumnReference>();
            Expression expression = null;
            boolean useDefault = false;
            if (updateAsgnFactor.column_definition_ref() != null) {
                factory = new OracleColumnRefFactory(updateAsgnFactor.column_definition_ref());
                ColumnReference columnReference = ((OracleColumnRefFactory)factory).generate();
                columnList = Arrays.asList(columnReference);
            }
            if (updateAsgnFactor.expr_or_default() != null) {
                Object exprOrDefault = updateAsgnFactor.expr_or_default();
                if (exprOrDefault.bit_expr() != null) {
                    OracleExpressionFactory factory2 = new OracleExpressionFactory(exprOrDefault.bit_expr());
                    expression = factory2.generate();
                }
                if (exprOrDefault.DEFAULT() != null) {
                    useDefault = true;
                }
            }
            if (updateAsgnFactor.column_list() != null) {
                for (OBParser.Column_definition_refContext column : updateAsgnFactor.column_list().column_definition_ref()) {
                    OracleColumnRefFactory factory3 = new OracleColumnRefFactory(column);
                    columnList.add(factory3.generate());
                }
            }
            if (updateAsgnFactor.subquery() != null) {
                factory = new OracleSelectBodyFactory(updateAsgnFactor.subquery());
                expression = ((OracleSelectBodyFactory)factory).generate();
            }
            returnVal.add(new UpdateAssign(updateAsgnFactor, columnList, expression, useDefault));
        }
        return returnVal;
    }
}

