/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement;

import com.oceanbase.tools.sqlparser.statement.Statement;
import lombok.NonNull;

public interface Expression
extends Statement {
    public Expression getParentReference();

    public Expression getReference();

    public ReferenceOperator getReferenceOperator();

    public ReferenceOperator getParentReferenceOperator();

    public Expression reference(@NonNull Expression var1, @NonNull ReferenceOperator var2);

    public Expression parentReference(@NonNull Expression var1, @NonNull ReferenceOperator var2);

    public static enum ReferenceOperator {
        DOT{

            @Override
            public String wrap(@NonNull String expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                return "." + expr;
            }
        }
        ,
        PAREN{

            @Override
            public String wrap(@NonNull String expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                return "(" + expr + ")";
            }
        }
        ,
        BRACKET{

            @Override
            public String wrap(@NonNull String expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                return "[" + expr + "]";
            }
        }
        ,
        BRACE{

            @Override
            public String wrap(@NonNull String expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                return "{" + expr + "}";
            }
        };


        public abstract String wrap(@NonNull String var1);
    }
}

