/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.Statement;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class BraceBlock
extends BaseExpression
implements FromReference {
    private final Statement wrappedTarget;
    private final String relation;

    public BraceBlock(@NonNull ParserRuleContext context, String relation, Statement wrappedTarget) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.wrappedTarget = wrappedTarget;
        this.relation = relation;
    }

    public BraceBlock(String relation, Statement wrappedTarget) {
        this.wrappedTarget = wrappedTarget;
        this.relation = relation;
    }

    @Override
    protected String doToString() {
        StringBuilder builder = new StringBuilder("{");
        if (this.relation != null) {
            builder.append(this.relation);
        }
        if (this.wrappedTarget != null) {
            builder.append(" ").append(this.wrappedTarget);
        }
        return builder.append("}").toString();
    }

    public Statement getWrappedTarget() {
        return this.wrappedTarget;
    }

    public String getRelation() {
        return this.relation;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BraceBlock)) {
            return false;
        }
        BraceBlock other = (BraceBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Statement this$wrappedTarget = this.getWrappedTarget();
        Statement other$wrappedTarget = other.getWrappedTarget();
        if (this$wrappedTarget == null ? other$wrappedTarget != null : !this$wrappedTarget.equals(other$wrappedTarget)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        return !(this$relation == null ? other$relation != null : !this$relation.equals(other$relation));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BraceBlock;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Statement $wrappedTarget = this.getWrappedTarget();
        result = result * 59 + ($wrappedTarget == null ? 43 : $wrappedTarget.hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        return result;
    }
}

