/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.BasePartition;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ListPartition
extends BasePartition {
    private boolean columns;

    public ListPartition(@NonNull ParserRuleContext context, @NonNull List<Expression> targets, @NonNull List<ListPartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum, boolean columns) {
        super(context, targets, partitionElements, subPartitionOption, partitionsNum);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (targets == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
        if (partitionElements == null) {
            throw new NullPointerException("partitionElements is marked non-null but is null");
        }
        this.columns = columns;
    }

    public ListPartition(@NonNull List<Expression> targets, @NonNull List<ListPartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum, boolean columns) {
        super(targets, partitionElements, subPartitionOption, partitionsNum);
        if (targets == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
        if (partitionElements == null) {
            throw new NullPointerException("partitionElements is marked non-null but is null");
        }
        this.columns = columns;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION BY LIST");
        if (this.columns) {
            builder.append(" COLUMNS");
        }
        builder.append("(").append(this.getPartitionTargets().stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (this.getSubPartitionOption() != null) {
            builder.append(" ").append(this.getSubPartitionOption());
        }
        if (this.getPartitionsNum() != null) {
            builder.append(" PARTITIONS ").append(this.getPartitionsNum());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getPartitionElements())) {
            builder.append(" (\n\t").append(this.getPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t"))).append("\n)");
        }
        return builder.toString();
    }

    public boolean isColumns() {
        return this.columns;
    }

    public void setColumns(boolean columns) {
        this.columns = columns;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPartition)) {
            return false;
        }
        ListPartition other = (ListPartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isColumns() == other.isColumns();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListPartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isColumns() ? 79 : 97);
        return result;
    }
}

