/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import com.oceanbase.tools.sqlparser.statement.createtable.ForeignReference;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class OutOfLineForeignConstraint
extends OutOfLineConstraint {
    private final ForeignReference reference;

    public OutOfLineForeignConstraint(@NonNull ParserRuleContext context, ConstraintState state, @NonNull List<SortColumn> columns, @NonNull ForeignReference reference) {
        super(context, state, columns);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        this.reference = reference;
    }

    public OutOfLineForeignConstraint(ConstraintState state, @NonNull List<SortColumn> columns, @NonNull ForeignReference reference) {
        super(state, columns);
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        this.reference = reference;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getConstraintName() != null) {
            builder.append(" CONSTRAINT ").append(this.getConstraintName());
        }
        builder.append(" FOREIGN KEY(").append(this.getColumns().stream().map(SortColumn::toString).collect(Collectors.joining(","))).append(") ").append(this.reference);
        if (this.getState() != null) {
            builder.append(" ").append(this.getState());
        }
        return builder.substring(1);
    }

    public ForeignReference getReference() {
        return this.reference;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutOfLineForeignConstraint)) {
            return false;
        }
        OutOfLineForeignConstraint other = (OutOfLineForeignConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForeignReference this$reference = this.getReference();
        ForeignReference other$reference = other.getReference();
        return !(this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OutOfLineForeignConstraint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ForeignReference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        return result;
    }
}

