/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.BaseSubPartitionElement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class SubRangePartitionElement
extends BaseSubPartitionElement {
    private final List<Expression> rangeExprs;

    public SubRangePartitionElement(@NonNull ParserRuleContext context, @NonNull String relation, @NonNull List<Expression> rangeExprs) {
        super(context, relation);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (rangeExprs == null) {
            throw new NullPointerException("rangeExprs is marked non-null but is null");
        }
        this.rangeExprs = rangeExprs;
    }

    public SubRangePartitionElement(@NonNull String relation, @NonNull List<Expression> rangeExprs) {
        super(relation);
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (rangeExprs == null) {
            throw new NullPointerException("rangeExprs is marked non-null but is null");
        }
        this.rangeExprs = rangeExprs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SUBPARTITION ").append(this.getRelationFactor()).append(" VALUES LESS THAN(").append(this.rangeExprs.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (this.getOptions() != null) {
            builder.append(" ").append(this.getOptions());
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubRangePartitionElement)) {
            return false;
        }
        SubRangePartitionElement other = (SubRangePartitionElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Expression> this$rangeExprs = this.getRangeExprs();
        List<Expression> other$rangeExprs = other.getRangeExprs();
        return !(this$rangeExprs == null ? other$rangeExprs != null : !((Object)this$rangeExprs).equals(other$rangeExprs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubRangePartitionElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Expression> $rangeExprs = this.getRangeExprs();
        result = result * 59 + ($rangeExprs == null ? 43 : ((Object)$rangeExprs).hashCode());
        return result;
    }

    public List<Expression> getRangeExprs() {
        return this.rangeExprs;
    }
}

