/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.select.FlashbackUsage;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.PartitionUsage;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Pivot;
import com.oceanbase.tools.sqlparser.statement.select.oracle.UnPivot;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class NameReference
extends BaseStatement
implements FromReference {
    private final String schema;
    private final String relation;
    private final String alias;
    private String userVariable;
    private PartitionUsage partitionUsage;
    private FlashbackUsage flashbackUsage;
    private Pivot pivot;
    private UnPivot unPivot;

    public NameReference(@NonNull ParserRuleContext context, String schema, @NonNull String relation, String alias) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.alias = alias;
    }

    public NameReference(@NonNull TerminalNode context, String schema, @NonNull String relation, String alias) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.alias = alias;
    }

    public NameReference(String schema, @NonNull String relation, String alias) {
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.alias = alias;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.schema != null) {
            buffer.append(this.schema).append(".");
        }
        buffer.append(this.relation);
        if (this.userVariable != null) {
            buffer.append(this.userVariable);
        }
        if (this.partitionUsage != null) {
            buffer.append(" ").append(this.partitionUsage.toString());
        }
        if (this.flashbackUsage != null) {
            buffer.append(" ").append(this.flashbackUsage.toString());
        }
        if (this.alias != null) {
            buffer.append(" ").append(this.alias);
        }
        if (this.pivot != null) {
            buffer.append(" ").append(this.pivot.toString());
        }
        if (this.unPivot != null) {
            buffer.append(" ").append(this.unPivot.toString());
        }
        return buffer.toString();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    public PartitionUsage getPartitionUsage() {
        return this.partitionUsage;
    }

    public FlashbackUsage getFlashbackUsage() {
        return this.flashbackUsage;
    }

    public Pivot getPivot() {
        return this.pivot;
    }

    public UnPivot getUnPivot() {
        return this.unPivot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameReference)) {
            return false;
        }
        NameReference other = (NameReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        if (this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable)) {
            return false;
        }
        PartitionUsage this$partitionUsage = this.getPartitionUsage();
        PartitionUsage other$partitionUsage = other.getPartitionUsage();
        if (this$partitionUsage == null ? other$partitionUsage != null : !((Object)this$partitionUsage).equals(other$partitionUsage)) {
            return false;
        }
        FlashbackUsage this$flashbackUsage = this.getFlashbackUsage();
        FlashbackUsage other$flashbackUsage = other.getFlashbackUsage();
        if (this$flashbackUsage == null ? other$flashbackUsage != null : !((Object)this$flashbackUsage).equals(other$flashbackUsage)) {
            return false;
        }
        Pivot this$pivot = this.getPivot();
        Pivot other$pivot = other.getPivot();
        if (this$pivot == null ? other$pivot != null : !((Object)this$pivot).equals(other$pivot)) {
            return false;
        }
        UnPivot this$unPivot = this.getUnPivot();
        UnPivot other$unPivot = other.getUnPivot();
        return !(this$unPivot == null ? other$unPivot != null : !((Object)this$unPivot).equals(other$unPivot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NameReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        PartitionUsage $partitionUsage = this.getPartitionUsage();
        result = result * 59 + ($partitionUsage == null ? 43 : ((Object)$partitionUsage).hashCode());
        FlashbackUsage $flashbackUsage = this.getFlashbackUsage();
        result = result * 59 + ($flashbackUsage == null ? 43 : ((Object)$flashbackUsage).hashCode());
        Pivot $pivot = this.getPivot();
        result = result * 59 + ($pivot == null ? 43 : ((Object)$pivot).hashCode());
        UnPivot $unPivot = this.getUnPivot();
        result = result * 59 + ($unPivot == null ? 43 : ((Object)$unPivot).hashCode());
        return result;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }

    public void setPartitionUsage(PartitionUsage partitionUsage) {
        this.partitionUsage = partitionUsage;
    }

    public void setFlashbackUsage(FlashbackUsage flashbackUsage) {
        this.flashbackUsage = flashbackUsage;
    }

    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    public void setUnPivot(UnPivot unPivot) {
        this.unPivot = unPivot;
    }
}

