/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.Operator;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.SubHashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubRangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.expression.CompoundExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleSubPartitionElementFactory
extends OBParserBaseVisitor<SubPartitionElement>
implements StatementFactory<SubPartitionElement> {
    private final ParserRuleContext parserRuleContext;

    public OracleSubPartitionElementFactory(@NonNull OBParser.Hash_subpartition_elementContext hashElementContext) {
        if (hashElementContext == null) {
            throw new NullPointerException("hashElementContext is marked non-null but is null");
        }
        this.parserRuleContext = hashElementContext;
    }

    public OracleSubPartitionElementFactory(@NonNull OBParser.Range_subpartition_elementContext rangeElementContext) {
        if (rangeElementContext == null) {
            throw new NullPointerException("rangeElementContext is marked non-null but is null");
        }
        this.parserRuleContext = rangeElementContext;
    }

    public OracleSubPartitionElementFactory(@NonNull OBParser.List_subpartition_elementContext listElementContext) {
        if (listElementContext == null) {
            throw new NullPointerException("listElementContext is marked non-null but is null");
        }
        this.parserRuleContext = listElementContext;
    }

    @Override
    public SubPartitionElement generate() {
        return (SubPartitionElement)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public SubPartitionElement visitHash_subpartition_element(OBParser.Hash_subpartition_elementContext ctx) {
        SubHashPartitionElement element = new SubHashPartitionElement((ParserRuleContext)ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()));
        element.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        element.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setPartitionOptions(OracleSubPartitionElementFactory.getPartitionOptions(ctx.physical_attributes_option_list()));
        return element;
    }

    @Override
    public SubPartitionElement visitRange_subpartition_element(OBParser.Range_subpartition_elementContext ctx) {
        List<Expression> rangeExprs = OracleSubPartitionElementFactory.getRangePartitionExprs(ctx.range_partition_expr());
        SubRangePartitionElement element = new SubRangePartitionElement(ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()), rangeExprs);
        element.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        element.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setPartitionOptions(OracleSubPartitionElementFactory.getPartitionOptions(ctx.physical_attributes_option_list()));
        return element;
    }

    @Override
    public SubPartitionElement visitList_subpartition_element(OBParser.List_subpartition_elementContext ctx) {
        List<Expression> listExprs = OracleSubPartitionElementFactory.getListPartitionExprs(ctx.list_partition_expr());
        SubListPartitionElement element = new SubListPartitionElement(ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()), listExprs);
        element.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        element.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setPartitionOptions(OracleSubPartitionElementFactory.getPartitionOptions(ctx.physical_attributes_option_list()));
        return element;
    }

    public static PartitionOptions getPartitionOptions(OBParser.Physical_attributes_option_listContext ctx) {
        if (ctx == null || ctx.physical_attributes_option().isEmpty()) {
            return null;
        }
        PartitionOptions partitionOptions = new PartitionOptions(ctx);
        ctx.physical_attributes_option().forEach(c -> {
            Integer num;
            Integer n = num = c.INTNUM() == null ? null : Integer.valueOf(c.INTNUM().getText());
            if (c.PCTFREE() != null) {
                partitionOptions.setPctFree(num);
            } else if (c.PCTUSED() != null) {
                partitionOptions.setPctUsed(num);
            } else if (c.INITRANS() != null) {
                partitionOptions.setIniTrans(num);
            } else if (c.MAXTRANS() != null) {
                partitionOptions.setMaxTrans(num);
            } else if (c.STORAGE() != null) {
                partitionOptions.setStorage(c.storage_options_list().storage_option().stream().map(i -> {
                    CharStream input = i.getStart().getInputStream();
                    return input.getText(Interval.of((int)i.getStart().getStartIndex(), (int)i.getStop().getStopIndex()));
                }).collect(Collectors.toList()));
            } else if (c.TABLESPACE() != null) {
                partitionOptions.setTableSpace(c.tablespace().getText());
            }
        });
        return partitionOptions;
    }

    public static List<Expression> getListPartitionExprs(OBParser.List_partition_exprContext context) {
        if (context.DEFAULT() != null) {
            return Collections.singletonList(new ConstExpression(context.DEFAULT()));
        }
        return context.list_expr().bit_expr().stream().map(c -> new OracleExpressionFactory((OBParser.Bit_exprContext)((Object)c)).generate()).collect(Collectors.toList());
    }

    public static List<Expression> getRangePartitionExprs(OBParser.Range_partition_exprContext cxt) {
        return OracleSubPartitionElementFactory.getRangePartitionExprs(cxt.range_expr_list());
    }

    public static List<Expression> getRangePartitionExprs(OBParser.Range_expr_listContext cxt) {
        return cxt.range_expr().stream().map(c -> {
            if (c.access_func_expr() != null) {
                return new OracleExpressionFactory().getFunctionCall(c.access_func_expr());
            }
            if (c.MAXVALUE() != null) {
                return new ConstExpression((ParserRuleContext)c);
            }
            Operator operator = null;
            if (c.Plus() != null) {
                operator = Operator.ADD;
            } else if (c.Minus() != null) {
                operator = Operator.SUB;
            }
            if (operator == null) {
                return new ConstExpression((ParserRuleContext)c);
            }
            return new CompoundExpression((ParserRuleContext)c, new ConstExpression(c.literal()), null, operator);
        }).collect(Collectors.toList());
    }
}

