/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSelectBodyFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSortKeyFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.SortKey;
import com.oceanbase.tools.sqlparser.statement.select.WithTable;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Fetch;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SearchMode;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SetValue;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;

public class OracleWithTableFactory
extends OBParserBaseVisitor<WithTable>
implements StatementFactory<WithTable> {
    private final OBParser.Common_table_exprContext commonTableExprContext;

    public OracleWithTableFactory(@NonNull OBParser.Common_table_exprContext commonTableExprContext) {
        if (commonTableExprContext == null) {
            throw new NullPointerException("commonTableExprContext is marked non-null but is null");
        }
        this.commonTableExprContext = commonTableExprContext;
    }

    @Override
    public WithTable generate() {
        return (WithTable)this.visit((ParseTree)this.commonTableExprContext);
    }

    @Override
    public WithTable visitCommon_table_expr(OBParser.Common_table_exprContext ctx) {
        SelectBody select;
        OracleSelectBodyFactory factory;
        String relationName = ctx.relation_name().getText();
        if (ctx.select_no_parens() != null) {
            factory = new OracleSelectBodyFactory(ctx.select_no_parens());
            select = (SelectBody)factory.generate();
            if (ctx.order_by() != null) {
                select.getLastSelectBody().setOrderBy(new OracleOrderByFactory(ctx.order_by()).generate());
            }
            if (ctx.fetch_next_clause() != null) {
                select.getLastSelectBody().setFetch(new OracleFetchFactory(ctx.fetch_next_clause()).generate());
            }
        } else if (ctx.with_select() != null) {
            factory = new OracleSelectBodyFactory(ctx.with_select());
            select = (SelectBody)factory.generate();
        } else if (ctx.select_with_parens() != null) {
            factory = new OracleSelectBodyFactory(ctx.select_with_parens());
            select = (SelectBody)factory.generate();
        } else {
            if (ctx.subquery() == null) {
                throw new IllegalStateException("Missing sub query");
            }
            factory = new OracleSelectBodyFactory(ctx.subquery());
            select = (SelectBody)factory.generate();
            OracleOrderByFactory orderByFactory = new OracleOrderByFactory(ctx.order_by());
            select.getLastSelectBody().setOrderBy((OrderBy)orderByFactory.generate());
            if (ctx.fetch_next_clause() != null) {
                OracleFetchFactory fetchFactory = new OracleFetchFactory(ctx.fetch_next_clause());
                select.getLastSelectBody().setFetch((Fetch)fetchFactory.generate());
            }
        }
        WithTable withTable = new WithTable(ctx, relationName, select);
        List<OBParser.Alias_name_listContext> aliasNameList = ctx.alias_name_list();
        if (CollectionUtils.isNotEmpty(aliasNameList)) {
            if (aliasNameList.size() == 1 && ctx.CYCLE() == null) {
                withTable.setAliasList(this.visitAliasNames(aliasNameList.get(0)));
            } else if (aliasNameList.size() != 1) {
                withTable.setAliasList(this.visitAliasNames(aliasNameList.get(0)));
                withTable.setCycleAliasList(this.visitAliasNames(aliasNameList.get(1)));
            } else {
                withTable.setCycleAliasList(this.visitAliasNames(aliasNameList.get(0)));
            }
        }
        if (ctx.SEARCH() != null) {
            SearchMode mode = ctx.BREADTH() != null ? SearchMode.BREADTH_FIRST : SearchMode.DEPTH_FIRST;
            withTable.setSearchMode(mode);
            if (ctx.sort_list() != null) {
                List<SortKey> sortKeys = ctx.sort_list().sort_key().stream().map(c -> {
                    OracleSortKeyFactory factory = new OracleSortKeyFactory((OBParser.Sort_keyContext)((Object)c));
                    return (SortKey)factory.generate();
                }).collect(Collectors.toList());
                withTable.setSearchSortKeyList(sortKeys);
            }
            if (ctx.search_set_value() != null) {
                SetValue setValue = new SetValue(ctx.search_set_value().var_name().getText(), null, null);
                withTable.setSearchValueSet(setValue);
            }
        }
        if (ctx.CYCLE() != null) {
            String name = ctx.var_name().getText();
            String value = ctx.STRING_VALUE(0) == null ? null : ctx.STRING_VALUE(0).getText();
            String defaultValue = ctx.STRING_VALUE(1) == null ? null : ctx.STRING_VALUE(1).getText();
            withTable.setCycleValueSet(new SetValue(name, value, defaultValue));
        }
        return withTable;
    }

    private List<String> visitAliasNames(OBParser.Alias_name_listContext ctx) {
        return ctx.column_alias_name().stream().map(c -> c.column_name().getText()).collect(Collectors.toList());
    }
}

