/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.Statement;
import com.oceanbase.tools.sqlparser.statement.common.WindowSpec;
import com.oceanbase.tools.sqlparser.statement.common.oracle.KeepClause;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class FunctionCall
extends BaseExpression {
    private static final Set<String> AGGREGATORS = new HashSet<String>();
    private final String functionName;
    private final List<FunctionParam> paramList;
    private final List<Statement> options = new ArrayList<Statement>();
    private KeepClause keep;
    private WindowSpec window;
    private OrderBy withinGroup;

    public FunctionCall(@NonNull ParserRuleContext context, @NonNull String functionName, @NonNull List<FunctionParam> functionParams) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (functionParams == null) {
            throw new NullPointerException("functionParams is marked non-null but is null");
        }
        this.functionName = functionName;
        this.paramList = functionParams;
    }

    public FunctionCall(@NonNull String functionName, @NonNull List<FunctionParam> functionParams) {
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (functionParams == null) {
            throw new NullPointerException("functionParams is marked non-null but is null");
        }
        this.functionName = functionName;
        this.paramList = functionParams;
    }

    public void addOption(Statement statement) {
        if (statement == null) {
            return;
        }
        this.options.add(statement);
    }

    public String getAggregator() {
        if (CollectionUtils.isEmpty(this.options)) {
            return null;
        }
        return this.options.stream().filter(s -> {
            if (!(s instanceof ConstExpression)) {
                return false;
            }
            String conS = ((ConstExpression)s).getExprConst();
            return AGGREGATORS.contains(conS.toUpperCase());
        }).map(s -> ((ConstExpression)s).getExprConst()).findFirst().orElse(null);
    }

    @Override
    public String doToString() {
        StringBuilder builder = new StringBuilder(this.functionName);
        builder.append("(");
        if (this.getAggregator() != null) {
            builder.append(this.getAggregator()).append(" ");
        }
        builder.append(this.paramList.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (this.keep != null) {
            builder.append(" KEEP (").append(this.keep).append(")");
        }
        if (this.withinGroup != null) {
            builder.append(" WITHIN GROUP (").append(this.withinGroup).append(")");
        }
        if (this.window != null) {
            builder.append(" OVER (").append(this.window.toString()).append(")");
        }
        return builder.toString();
    }

    public void setKeep(KeepClause keep) {
        this.keep = keep;
    }

    public void setWindow(WindowSpec window) {
        this.window = window;
    }

    public void setWithinGroup(OrderBy withinGroup) {
        this.withinGroup = withinGroup;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<FunctionParam> getParamList() {
        return this.paramList;
    }

    public List<Statement> getOptions() {
        return this.options;
    }

    public KeepClause getKeep() {
        return this.keep;
    }

    public WindowSpec getWindow() {
        return this.window;
    }

    public OrderBy getWithinGroup() {
        return this.withinGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        FunctionCall other = (FunctionCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        List<FunctionParam> this$paramList = this.getParamList();
        List<FunctionParam> other$paramList = other.getParamList();
        if (this$paramList == null ? other$paramList != null : !((Object)this$paramList).equals(other$paramList)) {
            return false;
        }
        List<Statement> this$options = this.getOptions();
        List<Statement> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        KeepClause this$keep = this.getKeep();
        KeepClause other$keep = other.getKeep();
        if (this$keep == null ? other$keep != null : !((Object)this$keep).equals(other$keep)) {
            return false;
        }
        WindowSpec this$window = this.getWindow();
        WindowSpec other$window = other.getWindow();
        if (this$window == null ? other$window != null : !((Object)this$window).equals(other$window)) {
            return false;
        }
        OrderBy this$withinGroup = this.getWithinGroup();
        OrderBy other$withinGroup = other.getWithinGroup();
        return !(this$withinGroup == null ? other$withinGroup != null : !((Object)this$withinGroup).equals(other$withinGroup));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FunctionCall;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        List<FunctionParam> $paramList = this.getParamList();
        result = result * 59 + ($paramList == null ? 43 : ((Object)$paramList).hashCode());
        List<Statement> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        KeepClause $keep = this.getKeep();
        result = result * 59 + ($keep == null ? 43 : ((Object)$keep).hashCode());
        WindowSpec $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : ((Object)$window).hashCode());
        OrderBy $withinGroup = this.getWithinGroup();
        result = result * 59 + ($withinGroup == null ? 43 : ((Object)$withinGroup).hashCode());
        return result;
    }

    static {
        AGGREGATORS.add("ALL");
        AGGREGATORS.add("DISTINCT");
        AGGREGATORS.add("UNIQUE");
    }
}

