/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.select.PartitionType;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class PartitionUsage
extends BaseStatement {
    private final PartitionType type;
    private final List<String> nameList;

    public PartitionUsage(@NonNull ParserRuleContext context, PartitionType type, @NonNull List<String> nameList) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (nameList == null) {
            throw new NullPointerException("nameList is marked non-null but is null");
        }
        this.type = type;
        this.nameList = nameList;
    }

    public PartitionUsage(PartitionType type, @NonNull List<String> nameList) {
        if (nameList == null) {
            throw new NullPointerException("nameList is marked non-null but is null");
        }
        this.type = type;
        this.nameList = nameList;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.type == PartitionType.PARTITION) {
            buffer.append("PARTITION ");
        } else {
            buffer.append("SUBPARTITION ");
        }
        return buffer.append("(").append(String.join((CharSequence)",", this.nameList)).append(")").toString();
    }

    public PartitionType getType() {
        return this.type;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionUsage)) {
            return false;
        }
        PartitionUsage other = (PartitionUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartitionType this$type = this.getType();
        PartitionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$nameList = this.getNameList();
        List<String> other$nameList = other.getNameList();
        return !(this$nameList == null ? other$nameList != null : !((Object)this$nameList).equals(other$nameList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartitionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $nameList = this.getNameList();
        result = result * 59 + ($nameList == null ? 43 : ((Object)$nameList).hashCode());
        return result;
    }
}

