/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.GroupBy;
import com.oceanbase.tools.sqlparser.statement.select.oracle.CubeGroupBy;
import com.oceanbase.tools.sqlparser.statement.select.oracle.GeneralGroupBy;
import com.oceanbase.tools.sqlparser.statement.select.oracle.GroupingSetsGroupBy;
import com.oceanbase.tools.sqlparser.statement.select.oracle.RollUpGroupBy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleGroupByFactory
extends OBParserBaseVisitor<GroupBy>
implements StatementFactory<GroupBy> {
    private final OBParser.Groupby_elementContext groupbyElementContext;

    public OracleGroupByFactory(@NonNull OBParser.Groupby_elementContext groupbyElementContext) {
        if (groupbyElementContext == null) {
            throw new NullPointerException("groupbyElementContext is marked non-null but is null");
        }
        this.groupbyElementContext = groupbyElementContext;
    }

    @Override
    public GroupBy generate() {
        return (GroupBy)this.visit((ParseTree)this.groupbyElementContext);
    }

    @Override
    public GroupBy visitGroupby_element(OBParser.Groupby_elementContext ctx) {
        if (ctx.group_by_expr() != null) {
            return (GroupBy)this.visit((ParseTree)ctx.group_by_expr());
        }
        if (ctx.rollup_clause() != null) {
            return (GroupBy)this.visit((ParseTree)ctx.rollup_clause());
        }
        if (ctx.cube_clause() != null) {
            return (GroupBy)this.visit((ParseTree)ctx.cube_clause());
        }
        if (ctx.grouping_sets_clause() != null) {
            return (GroupBy)this.visit((ParseTree)ctx.grouping_sets_clause());
        }
        return new GroupingSetsGroupBy((ParserRuleContext)ctx, new ArrayList<GroupBy>());
    }

    @Override
    public GroupBy visitGroup_by_expr(OBParser.Group_by_exprContext ctx) {
        OracleExpressionFactory factory = new OracleExpressionFactory(ctx.bit_expr());
        return new GeneralGroupBy((ParserRuleContext)ctx, (Expression)factory.generate());
    }

    @Override
    public GroupBy visitRollup_clause(OBParser.Rollup_clauseContext ctx) {
        return new RollUpGroupBy((ParserRuleContext)ctx, this.getExpressions(ctx.group_by_expr_list().group_by_expr()));
    }

    @Override
    public GroupBy visitCube_clause(OBParser.Cube_clauseContext ctx) {
        return new CubeGroupBy((ParserRuleContext)ctx, this.getExpressions(ctx.group_by_expr_list().group_by_expr()));
    }

    @Override
    public GroupBy visitGrouping_sets_clause(OBParser.Grouping_sets_clauseContext ctx) {
        List<GroupBy> groupByList = ctx.grouping_sets_list().grouping_sets().stream().map(child -> {
            if (child.group_by_expr() != null) {
                return (GroupBy)this.visit((ParseTree)child.group_by_expr());
            }
            if (child.rollup_clause() != null) {
                return (GroupBy)this.visit((ParseTree)child.rollup_clause());
            }
            if (child.cube_clause() != null) {
                return (GroupBy)this.visit((ParseTree)child.cube_clause());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return new GroupingSetsGroupBy((ParserRuleContext)ctx, groupByList);
    }

    private List<Expression> getExpressions(List<OBParser.Group_by_exprContext> groupByExprs) {
        return groupByExprs.stream().map(c -> {
            OracleExpressionFactory factory = new OracleExpressionFactory(c.bit_expr());
            return (Expression)factory.generate();
        }).collect(Collectors.toList());
    }
}

