/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleProjectionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.oracle.Returning;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleReturningFactory
extends OBParserBaseVisitor<Returning>
implements StatementFactory<Returning> {
    private final ParserRuleContext context;

    public OracleReturningFactory(@NonNull OBParser.Returning_clauseContext returningClauseContext) {
        if (returningClauseContext == null) {
            throw new NullPointerException("returningClauseContext is marked non-null but is null");
        }
        this.context = returningClauseContext;
    }

    @Override
    public Returning generate() {
        return (Returning)this.visit((ParseTree)this.context);
    }

    @Override
    public Returning visitReturning_clause(OBParser.Returning_clauseContext ctx) {
        List<Projection> projectionList = ctx.returning_exprs().projection().stream().map(c -> new OracleProjectionFactory((OBParser.ProjectionContext)((Object)c)).generate()).collect(Collectors.toList());
        List<Expression> intoList = new ArrayList<Expression>();
        OBParser.Into_clauseContext intoCtx = ctx.opt_into_clause().into_clause();
        boolean bulkCollect = false;
        if (intoCtx != null) {
            intoList = intoCtx.into_var_list().into_var().stream().map(c -> {
                if (c.USER_VARIABLE() != null) {
                    return new ConstExpression(c.USER_VARIABLE());
                }
                if (c.obj_access_ref_normal() != null) {
                    return new OracleExpressionFactory().visit((ParseTree)c.obj_access_ref_normal());
                }
                if (c.QUESTIONMARK() != null) {
                    return new ConstExpression(c.QUESTIONMARK());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (intoCtx.BULK() != null && intoCtx.COLLECT() != null) {
                bulkCollect = true;
            }
        }
        Returning returning = new Returning(ctx, intoList, projectionList);
        returning.setBulkCollect(bulkCollect);
        return returning;
    }
}

