/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleGroupByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleProjectionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleWithTableFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.GroupBy;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import com.oceanbase.tools.sqlparser.statement.select.RelatedSelectBody;
import com.oceanbase.tools.sqlparser.statement.select.RelationType;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.WithTable;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Fetch;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class OracleSelectBodyFactory
extends OBParserBaseVisitor<SelectBody>
implements StatementFactory<SelectBody> {
    private OBParser.SubqueryContext subqueryContext = null;
    private OBParser.Select_no_parensContext selectNoParensContext = null;
    private OBParser.With_selectContext withSelectContext = null;
    private OBParser.Select_with_parensContext selectWithParensContext = null;

    public OracleSelectBodyFactory(@NonNull OBParser.With_selectContext withSelectContext) {
        if (withSelectContext == null) {
            throw new NullPointerException("withSelectContext is marked non-null but is null");
        }
        this.withSelectContext = withSelectContext;
    }

    public OracleSelectBodyFactory(@NonNull OBParser.Select_no_parensContext selectNoParensContext) {
        if (selectNoParensContext == null) {
            throw new NullPointerException("selectNoParensContext is marked non-null but is null");
        }
        this.selectNoParensContext = selectNoParensContext;
    }

    public OracleSelectBodyFactory(@NonNull OBParser.SubqueryContext subqueryContext) {
        if (subqueryContext == null) {
            throw new NullPointerException("subqueryContext is marked non-null but is null");
        }
        this.subqueryContext = subqueryContext;
    }

    public OracleSelectBodyFactory(@NonNull OBParser.Select_with_parensContext selectWithParensContext) {
        if (selectWithParensContext == null) {
            throw new NullPointerException("selectWithParensContext is marked non-null but is null");
        }
        this.selectWithParensContext = selectWithParensContext;
    }

    @Override
    public SelectBody generate() {
        if (this.selectNoParensContext != null) {
            return (SelectBody)this.visit((ParseTree)this.selectNoParensContext);
        }
        if (this.subqueryContext != null) {
            return (SelectBody)this.visit((ParseTree)this.subqueryContext);
        }
        if (this.selectWithParensContext != null) {
            return (SelectBody)this.visit((ParseTree)this.selectWithParensContext);
        }
        if (this.withSelectContext != null) {
            return (SelectBody)this.visit((ParseTree)this.withSelectContext);
        }
        throw new IllegalStateException("No Context available");
    }

    @Override
    public SelectBody visitSubquery(OBParser.SubqueryContext ctx) {
        if (ctx.select_no_parens() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.select_no_parens());
        }
        if (ctx.select_with_parens() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.select_with_parens());
        }
        if (ctx.with_select() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.with_select());
        }
        throw new IllegalStateException("No alternative node");
    }

    @Override
    public SelectBody visitSelect_with_parens(OBParser.Select_with_parensContext ctx) {
        OBParserBaseVisitor factory;
        SelectBody select;
        if (ctx.select_with_parens() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.select_with_parens());
        }
        if (ctx.select_no_parens() != null) {
            select = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_no_parens()));
        } else if (ctx.with_select() != null) {
            select = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.with_select()));
        } else {
            throw new IllegalStateException("No alternative node");
        }
        if (ctx.order_by() != null) {
            factory = new OracleOrderByFactory(ctx.order_by());
            select.getLastSelectBody().setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.fetch_next_clause() != null) {
            factory = new OracleFetchFactory(ctx.fetch_next_clause());
            select.getLastSelectBody().setFetch((Fetch)factory.generate());
        }
        return select;
    }

    @Override
    public SelectBody visitSelect_no_parens(OBParser.Select_no_parensContext ctx) {
        if (ctx.select_clause() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.select_clause());
        }
        return (SelectBody)this.visit((ParseTree)ctx.select_clause_set());
    }

    @Override
    public SelectBody visitWith_select(OBParser.With_selectContext ctx) {
        SelectBody select = ctx.select_no_parens() != null ? new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_no_parens())) : new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_with_parens()));
        OBParser.With_clauseContext withClause = ctx.with_clause();
        if (withClause.RECURSIVE() != null) {
            select.setRecursive(true);
        }
        if (withClause.common_table_expr() != null) {
            OracleWithTableFactory factory = new OracleWithTableFactory(withClause.common_table_expr());
            select.getWith().add((WithTable)factory.generate());
        } else if (withClause.with_list() != null) {
            withClause.with_list().common_table_expr().forEach(c -> {
                OracleWithTableFactory factory = new OracleWithTableFactory((OBParser.Common_table_exprContext)((Object)c));
                select.getWith().add((WithTable)factory.generate());
            });
        }
        return select;
    }

    @Override
    public SelectBody visitSelect_clause_set(OBParser.Select_clause_setContext ctx) {
        RelationType relationType;
        SelectBody left;
        SelectBody right = (SelectBody)this.visit((ParseTree)ctx.select_clause_set_right());
        if (ctx.select_clause_set() != null) {
            left = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set()));
        } else if (ctx.select_clause_set_left() != null) {
            left = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set_left()));
        } else {
            throw new IllegalStateException("Node is not found");
        }
        OBParser.Set_typeContext type = ctx.set_type();
        if (type == null) {
            throw new IllegalStateException("Missing set top node");
        }
        if (type.set_type_other() != null) {
            relationType = RelationType.valueOf(type.set_type_other().getText());
        } else {
            OBParser.Set_expression_optionContext o = type.set_expression_option();
            relationType = RelationType.UNION;
            if (o != null && o.ALL() != null) {
                relationType = RelationType.UNION_ALL;
            }
        }
        left.getLastSelectBody().setRelatedSelect(new RelatedSelectBody(right, relationType));
        return left;
    }

    @Override
    public SelectBody visitSelect_clause_set_right(OBParser.Select_clause_set_rightContext ctx) {
        if (ctx.simple_select() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.simple_select());
        }
        if (ctx.select_with_hierarchical_query() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.select_with_hierarchical_query());
        }
        return (SelectBody)this.visit((ParseTree)ctx.select_with_parens());
    }

    @Override
    public SelectBody visitSelect_clause_set_left(OBParser.Select_clause_set_leftContext ctx) {
        return (SelectBody)this.visit((ParseTree)ctx.select_clause_set_right());
    }

    @Override
    public SelectBody visitSelect_clause(OBParser.Select_clauseContext ctx) {
        if (ctx.simple_select() != null) {
            return (SelectBody)this.visit((ParseTree)ctx.simple_select());
        }
        return (SelectBody)this.visit((ParseTree)ctx.select_with_hierarchical_query());
    }

    @Override
    public SelectBody visitSelect_with_hierarchical_query(final OBParser.Select_with_hierarchical_queryContext ctx) {
        OracleExpressionFactory factory;
        SelectBody select = this.visitSelect(new SelectContext(){

            @Override
            public ParserRuleContext getTarget() {
                return ctx;
            }

            @Override
            public OBParser.Select_expr_listContext projectionList() {
                return ctx.select_expr_list();
            }

            @Override
            public OBParser.From_listContext fromList() {
                return ctx.from_list();
            }

            @Override
            public OBParser.Groupby_clauseContext groupClause() {
                return ctx.groupby_clause();
            }

            @Override
            public TerminalNode whereNode() {
                return ctx.WHERE();
            }

            @Override
            public TerminalNode havingNode() {
                return ctx.HAVING();
            }

            @Override
            public List<OBParser.ExprContext> exprList() {
                return ctx.expr();
            }

            @Override
            public OBParser.Query_expression_option_listContext queryOptionList() {
                return ctx.query_expression_option_list();
            }
        });
        if (ctx.start_with() != null) {
            factory = new OracleExpressionFactory(ctx.start_with().expr());
            select.setStartWith((Expression)factory.generate());
        }
        if (ctx.connect_by() != null) {
            factory = new OracleExpressionFactory(ctx.connect_by().expr());
            select.setConnectBy((Expression)factory.generate());
        }
        return select;
    }

    @Override
    public SelectBody visitSimple_select(final OBParser.Simple_selectContext ctx) {
        return this.visitSelect(new SelectContext(){

            @Override
            public ParserRuleContext getTarget() {
                return ctx;
            }

            @Override
            public OBParser.Select_expr_listContext projectionList() {
                return ctx.select_expr_list();
            }

            @Override
            public OBParser.From_listContext fromList() {
                return ctx.from_list();
            }

            @Override
            public OBParser.Groupby_clauseContext groupClause() {
                return ctx.groupby_clause();
            }

            @Override
            public TerminalNode whereNode() {
                return ctx.WHERE();
            }

            @Override
            public TerminalNode havingNode() {
                return ctx.HAVING();
            }

            @Override
            public List<OBParser.ExprContext> exprList() {
                return ctx.expr();
            }

            @Override
            public OBParser.Query_expression_option_listContext queryOptionList() {
                return ctx.query_expression_option_list();
            }
        });
    }

    private SelectBody visitSelect(SelectContext ctx) {
        OracleExpressionFactory factory;
        List<Projection> selectItems = this.visitProjectionList(ctx.projectionList());
        List<FromReference> froms = this.visitFromList(ctx.fromList());
        SelectBody select = new SelectBody(ctx.getTarget(), selectItems, froms);
        OBParser.ExprContext where = null;
        OBParser.ExprContext having = null;
        if (ctx.whereNode() != null && ctx.havingNode() != null) {
            where = ctx.exprList().get(0);
            if (where == null) {
                throw new IllegalStateException("Missing where clause");
            }
            having = ctx.exprList().get(1);
            if (having == null) {
                throw new IllegalStateException("Missing having clause");
            }
        } else if (ctx.whereNode() == null && ctx.havingNode() != null) {
            having = ctx.exprList().get(0);
        } else if (ctx.havingNode() == null && ctx.whereNode() != null) {
            where = ctx.exprList().get(0);
        }
        if (where != null) {
            factory = new OracleExpressionFactory(where);
            select.setWhere((Expression)factory.generate());
        }
        if (having != null) {
            factory = new OracleExpressionFactory(having);
            select.setHaving((Expression)factory.generate());
        }
        if (ctx.groupClause() != null) {
            select.setGroupBy(this.visitGroupByClause(ctx.groupClause()));
        }
        if (ctx.queryOptionList() != null) {
            select.setQueryOptions(this.getQueryExpr(ctx.queryOptionList()));
        }
        return select;
    }

    private String getQueryExpr(OBParser.Query_expression_option_listContext context) {
        return context.query_expression_option().stream().map(RuleContext::getText).collect(Collectors.joining(" "));
    }

    private List<Projection> visitProjectionList(OBParser.Select_expr_listContext context) {
        return context.projection().stream().map(child -> {
            OracleProjectionFactory factory = new OracleProjectionFactory((OBParser.ProjectionContext)((Object)child));
            return factory.generate();
        }).collect(Collectors.toList());
    }

    private List<FromReference> visitFromList(OBParser.From_listContext context) {
        return context.table_references().table_reference().stream().map(c -> {
            OracleFromReferenceFactory factory = new OracleFromReferenceFactory((OBParser.Table_referenceContext)((Object)c));
            return (FromReference)factory.generate();
        }).collect(Collectors.toList());
    }

    private List<GroupBy> visitGroupByClause(OBParser.Groupby_clauseContext context) {
        return context.groupby_element_list().groupby_element().stream().map(c -> {
            OracleGroupByFactory factory = new OracleGroupByFactory((OBParser.Groupby_elementContext)((Object)c));
            return (GroupBy)factory.generate();
        }).collect(Collectors.toList());
    }

    static interface SelectContext {
        public ParserRuleContext getTarget();

        public OBParser.Select_expr_listContext projectionList();

        public OBParser.From_listContext fromList();

        public OBParser.Groupby_clauseContext groupClause();

        public TerminalNode whereNode();

        public TerminalNode havingNode();

        public List<OBParser.ExprContext> exprList();

        public OBParser.Query_expression_option_listContext queryOptionList();
    }
}

