/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.TableOptions;
import com.oceanbase.tools.sqlparser.statement.expression.BoolValue;
import com.oceanbase.tools.sqlparser.statement.expression.CollectionExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleTableOptionsFactory
extends OBParserBaseVisitor<TableOptions>
implements StatementFactory<TableOptions> {
    private final ParserRuleContext parserRuleContext;

    public OracleTableOptionsFactory(@NonNull OBParser.Table_option_listContext tableOptionListContext) {
        if (tableOptionListContext == null) {
            throw new NullPointerException("tableOptionListContext is marked non-null but is null");
        }
        this.parserRuleContext = tableOptionListContext;
    }

    public OracleTableOptionsFactory(@NonNull OBParser.Table_option_list_space_seperatedContext tableOptionListContext) {
        if (tableOptionListContext == null) {
            throw new NullPointerException("tableOptionListContext is marked non-null but is null");
        }
        this.parserRuleContext = tableOptionListContext;
    }

    @Override
    public TableOptions generate() {
        return (TableOptions)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public TableOptions visitTable_option_list(OBParser.Table_option_listContext ctx) {
        if (ctx.table_option_list_space_seperated() != null) {
            return (TableOptions)this.visit((ParseTree)ctx.table_option_list_space_seperated());
        }
        TableOptions target = new TableOptions(ctx);
        target.merge((BaseOptions)this.visit((ParseTree)ctx.table_option()));
        target.merge((BaseOptions)this.visit((ParseTree)ctx.table_option_list()));
        return target;
    }

    @Override
    public TableOptions visitTable_option_list_space_seperated(OBParser.Table_option_list_space_seperatedContext ctx) {
        TableOptions target = new TableOptions(ctx);
        target.merge((BaseOptions)this.visit((ParseTree)ctx.table_option()));
        if (ctx.table_option_list_space_seperated() != null) {
            target.merge((BaseOptions)this.visit((ParseTree)ctx.table_option_list_space_seperated()));
        }
        return target;
    }

    @Override
    public TableOptions visitTable_option(OBParser.Table_optionContext ctx) {
        TableOptions target = new TableOptions(ctx);
        if (ctx.SORTKEY() != null) {
            target.setSortKeys(ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList()));
        } else if (ctx.parallel_option() != null) {
            target.merge((BaseOptions)this.visit((ParseTree)ctx.parallel_option()));
        } else if (ctx.TABLE_MODE() != null) {
            target.setTableMode(ctx.STRING_VALUE().getText());
        } else if (ctx.DUPLICATE_SCOPE() != null) {
            target.setDuplicateScope(ctx.STRING_VALUE().getText());
        } else if (ctx.LOCALITY() != null) {
            String force = ctx.FORCE() == null ? "" : " " + ctx.FORCE().getText();
            target.setLocality(ctx.locality_name().getText() + force);
        } else if (ctx.EXPIRE_INFO() != null) {
            target.setExpireInfo(new OracleExpressionFactory(ctx.bit_expr()).generate());
        } else if (ctx.PROGRESSIVE_MERGE_NUM() != null) {
            target.setProgressiveMergeNum(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.BLOCK_SIZE() != null) {
            target.setBlockSize(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.TABLE_ID() != null) {
            target.setTableId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.REPLICA_NUM() != null) {
            target.setReplicaNum(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.compress_option() != null) {
            target.merge((BaseOptions)this.visit((ParseTree)ctx.compress_option()));
        } else if (ctx.USE_BLOOM_FILTER() != null) {
            target.setUseBloomFilter(Boolean.valueOf(ctx.BOOL_VALUE().getText()));
        } else if (ctx.PRIMARY_ZONE() != null) {
            target.setPrimaryZone(ctx.primary_zone_name().getText());
        } else if (ctx.TABLEGROUP() != null) {
            target.setTableGroup(ctx.relation_name_or_string().getText());
        } else if (ctx.read_only_or_write() != null) {
            if (ctx.read_only_or_write().ONLY() != null) {
                target.setReadOnly(true);
            } else if (ctx.read_only_or_write().WRITE() != null) {
                target.setReadWrite(true);
            }
        } else if (ctx.ENGINE_() != null) {
            target.setEngine(ctx.relation_name_or_string().getText());
        } else if (ctx.TABLET_SIZE() != null) {
            target.setTabletSize(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.MAX_USED_PART_ID() != null) {
            target.setMaxUsedPartId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.ENABLE() != null && ctx.ROW() != null) {
            target.setEnableRowMovement(true);
        } else if (ctx.DISABLE() != null && ctx.ROW() != null) {
            target.setDisableRowMovement(true);
        } else if (ctx.physical_attributes_option() != null) {
            target.merge((BaseOptions)this.visit((ParseTree)ctx.physical_attributes_option()));
        } else if (ctx.ENABLE_EXTENDED_ROWID() != null) {
            target.setEnableExtendedRowId(Boolean.valueOf(ctx.BOOL_VALUE().getText()));
        } else if (ctx.LOCATION() != null) {
            target.setLocation(ctx.STRING_VALUE().getText());
        } else if (ctx.FORMAT() != null) {
            HashMap<String, Expression> formatMap = new HashMap<String, Expression>();
            ctx.external_file_format_list().external_file_format().forEach(e -> {
                Expression value = null;
                if (e.STRING_VALUE() != null) {
                    value = new ConstExpression(e.STRING_VALUE());
                } else if (e.bit_expr() != null) {
                    value = new OracleExpressionFactory(e.bit_expr()).generate();
                } else if (e.INTNUM() != null) {
                    value = new ConstExpression(e.INTNUM());
                } else if (e.BOOL_VALUE() != null) {
                    value = new BoolValue(e.BOOL_VALUE());
                } else if (e.expr_list() != null) {
                    List<Expression> exprs = e.expr_list().bit_expr().stream().map(ex -> new OracleExpressionFactory((OBParser.Bit_exprContext)((Object)((Object)ex))).generate()).collect(Collectors.toList());
                    value = new CollectionExpression((ParserRuleContext)e.expr_list(), exprs);
                }
                formatMap.put(e.format_key.getText().toUpperCase(), value);
            });
            target.setFormat(formatMap);
        } else if (ctx.PATTERN() != null) {
            target.setPattern(ctx.STRING_VALUE().getText());
        }
        return target;
    }

    @Override
    public TableOptions visitParallel_option(OBParser.Parallel_optionContext ctx) {
        TableOptions tableOptions = new TableOptions(ctx);
        if (ctx.NOPARALLEL() != null) {
            tableOptions.setNoParallel(true);
        } else {
            tableOptions.setParallel(Integer.valueOf(ctx.INTNUM().getText()));
        }
        return tableOptions;
    }

    @Override
    public TableOptions visitCompress_option(OBParser.Compress_optionContext ctx) {
        TableOptions tableOptions = new TableOptions(ctx);
        if (ctx.NOCOMPRESS() != null) {
            tableOptions.setNoCompress(true);
            return tableOptions;
        }
        CharStream input = ctx.getStart().getInputStream();
        String str = input.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
        int index = str.indexOf(ctx.COMPRESS().getText());
        if (index >= 0) {
            str = str.substring(index + ctx.COMPRESS().getText().length()).trim();
        }
        tableOptions.setCompress(str);
        return tableOptions;
    }

    @Override
    public TableOptions visitPhysical_attributes_option(OBParser.Physical_attributes_optionContext ctx) {
        Integer num;
        TableOptions tableOptions = new TableOptions(ctx);
        Integer n = num = ctx.INTNUM() == null ? null : Integer.valueOf(ctx.INTNUM().getText());
        if (ctx.PCTFREE() != null) {
            tableOptions.setPctFree(num);
        } else if (ctx.PCTUSED() != null) {
            tableOptions.setPctUsed(num);
        } else if (ctx.INITRANS() != null) {
            tableOptions.setIniTrans(num);
        } else if (ctx.MAXTRANS() != null) {
            tableOptions.setMaxTrans(num);
        } else if (ctx.STORAGE() != null) {
            tableOptions.setStorage(ctx.storage_options_list().storage_option().stream().map(i -> {
                CharStream input = i.getStart().getInputStream();
                return input.getText(Interval.of((int)i.getStart().getStartIndex(), (int)i.getStop().getStopIndex()));
            }).collect(Collectors.toList()));
        } else if (ctx.TABLESPACE() != null) {
            tableOptions.setTableSpace(ctx.tablespace().getText());
        }
        return tableOptions;
    }
}

