/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.createtable.BasePartition;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class KeyPartition
extends BasePartition {
    public KeyPartition(@NonNull ParserRuleContext context, List<ColumnReference> columns, List<HashPartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum) {
        super(context, columns, partitionElements, subPartitionOption, partitionsNum);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public KeyPartition(List<ColumnReference> columns, List<HashPartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum) {
        super(columns, partitionElements, subPartitionOption, partitionsNum);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION BY KEY");
        builder.append("(");
        if (this.getPartitionTargets() != null) {
            builder.append(this.getPartitionTargets().stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        builder.append(")");
        if (this.getSubPartitionOption() != null) {
            builder.append(" ").append(this.getSubPartitionOption());
        }
        if (this.getPartitionsNum() != null) {
            builder.append(" PARTITIONS ").append(this.getPartitionsNum());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getPartitionElements())) {
            builder.append(" (\n\t").append(this.getPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t"))).append("\n)");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyPartition)) {
            return false;
        }
        KeyPartition other = (KeyPartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KeyPartition;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

