/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.FlashBackType;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class FlashbackUsage
extends BaseStatement {
    private final FlashBackType type;
    private final Expression expression;

    public FlashbackUsage(@NonNull ParserRuleContext context, @NonNull FlashBackType type, @NonNull Expression expression) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        this.type = type;
        this.expression = expression;
    }

    public FlashbackUsage(@NonNull FlashBackType type, @NonNull Expression expression) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        this.type = type;
        this.expression = expression;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("AS OF ");
        if (this.type == FlashBackType.AS_OF_TIMESTAMP) {
            buffer.append("TIMESTAMP ");
        } else if (this.type == FlashBackType.AS_OF_SCN) {
            buffer.append("SCN ");
        } else {
            buffer.append("SNAPSHOT ");
        }
        return buffer.append(this.expression.toString()).toString();
    }

    public FlashBackType getType() {
        return this.type;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlashbackUsage)) {
            return false;
        }
        FlashbackUsage other = (FlashbackUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FlashBackType this$type = this.getType();
        FlashBackType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Expression this$expression = this.getExpression();
        Expression other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlashbackUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FlashBackType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Expression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }
}

