/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select.oracle;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class UnPivot
extends BaseStatement {
    private final boolean includeNulls;
    private final List<ColumnReference> forColumns;
    private final List<InItem> inItems;
    private final List<ColumnReference> unpivotColumns;
    private String alias;

    public UnPivot(@NonNull ParserRuleContext context, boolean includeNulls, @NonNull List<ColumnReference> unpivotColumns, @NonNull List<ColumnReference> forColumns, @NonNull List<InItem> inItems) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (unpivotColumns == null) {
            throw new NullPointerException("unpivotColumns is marked non-null but is null");
        }
        if (forColumns == null) {
            throw new NullPointerException("forColumns is marked non-null but is null");
        }
        if (inItems == null) {
            throw new NullPointerException("inItems is marked non-null but is null");
        }
        this.inItems = inItems;
        this.includeNulls = includeNulls;
        this.unpivotColumns = unpivotColumns;
        this.forColumns = forColumns;
    }

    public UnPivot(boolean includeNulls, @NonNull List<ColumnReference> unpivotColumns, @NonNull List<ColumnReference> forColumns, @NonNull List<InItem> inItems) {
        if (unpivotColumns == null) {
            throw new NullPointerException("unpivotColumns is marked non-null but is null");
        }
        if (forColumns == null) {
            throw new NullPointerException("forColumns is marked non-null but is null");
        }
        if (inItems == null) {
            throw new NullPointerException("inItems is marked non-null but is null");
        }
        this.inItems = inItems;
        this.includeNulls = includeNulls;
        this.unpivotColumns = unpivotColumns;
        this.forColumns = forColumns;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UNPIVOT");
        if (this.includeNulls) {
            builder.append(" INCLUDE NULLS");
        } else {
            builder.append(" EXCLUDE NULLS");
        }
        builder.append("(");
        if (this.unpivotColumns.size() == 1) {
            builder.append(this.unpivotColumns.get(0));
        } else {
            builder.append("(").append(this.unpivotColumns.stream().map(BaseExpression::toString).collect(Collectors.joining(","))).append(")");
        }
        builder.append(" FOR ");
        if (this.forColumns.size() == 1) {
            builder.append(this.forColumns.get(0));
        } else {
            builder.append("(").append(this.forColumns.stream().map(BaseExpression::toString).collect(Collectors.joining(","))).append(")");
        }
        builder.append(" IN(").append(this.inItems.stream().map(InItem::toString).collect(Collectors.joining(","))).append(")").append(")");
        if (this.alias != null) {
            builder.append(" ").append(this.alias);
        }
        return builder.toString();
    }

    public boolean isIncludeNulls() {
        return this.includeNulls;
    }

    public List<ColumnReference> getForColumns() {
        return this.forColumns;
    }

    public List<InItem> getInItems() {
        return this.inItems;
    }

    public List<ColumnReference> getUnpivotColumns() {
        return this.unpivotColumns;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnPivot)) {
            return false;
        }
        UnPivot other = (UnPivot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeNulls() != other.isIncludeNulls()) {
            return false;
        }
        List<ColumnReference> this$forColumns = this.getForColumns();
        List<ColumnReference> other$forColumns = other.getForColumns();
        if (this$forColumns == null ? other$forColumns != null : !((Object)this$forColumns).equals(other$forColumns)) {
            return false;
        }
        List<InItem> this$inItems = this.getInItems();
        List<InItem> other$inItems = other.getInItems();
        if (this$inItems == null ? other$inItems != null : !((Object)this$inItems).equals(other$inItems)) {
            return false;
        }
        List<ColumnReference> this$unpivotColumns = this.getUnpivotColumns();
        List<ColumnReference> other$unpivotColumns = other.getUnpivotColumns();
        if (this$unpivotColumns == null ? other$unpivotColumns != null : !((Object)this$unpivotColumns).equals(other$unpivotColumns)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnPivot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeNulls() ? 79 : 97);
        List<ColumnReference> $forColumns = this.getForColumns();
        result = result * 59 + ($forColumns == null ? 43 : ((Object)$forColumns).hashCode());
        List<InItem> $inItems = this.getInItems();
        result = result * 59 + ($inItems == null ? 43 : ((Object)$inItems).hashCode());
        List<ColumnReference> $unpivotColumns = this.getUnpivotColumns();
        result = result * 59 + ($unpivotColumns == null ? 43 : ((Object)$unpivotColumns).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public static class InItem
    extends BaseStatement {
        private final Expression as;
        private final List<ColumnReference> columns;

        public InItem(@NonNull ParserRuleContext context, @NonNull List<ColumnReference> columns, Expression as) {
            super(context);
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            if (columns == null) {
                throw new NullPointerException("columns is marked non-null but is null");
            }
            this.as = as;
            this.columns = columns;
        }

        public InItem(@NonNull List<ColumnReference> columns, Expression as) {
            if (columns == null) {
                throw new NullPointerException("columns is marked non-null but is null");
            }
            this.as = as;
            this.columns = columns;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.columns.size() > 1) {
                builder.append("(");
            }
            builder.append(this.columns.stream().map(BaseExpression::toString).collect(Collectors.joining(",")));
            if (this.columns.size() > 1) {
                builder.append(")");
            }
            if (this.as != null) {
                builder.append(" AS ").append(this.as.toString());
            }
            return builder.toString();
        }

        public Expression getAs() {
            return this.as;
        }

        public List<ColumnReference> getColumns() {
            return this.columns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InItem)) {
                return false;
            }
            InItem other = (InItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$as = this.getAs();
            Expression other$as = other.getAs();
            if (this$as == null ? other$as != null : !this$as.equals(other$as)) {
                return false;
            }
            List<ColumnReference> this$columns = this.getColumns();
            List<ColumnReference> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $as = this.getAs();
            result = result * 59 + ($as == null ? 43 : $as.hashCode());
            List<ColumnReference> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }
    }
}

