/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser;

import lombok.NonNull;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class SyntaxErrorException
extends ParseCancellationException {
    private final int start;
    private final int stop;
    private final String text;

    public SyntaxErrorException(@NonNull Recognizer<?, ?> recognizer, @NonNull RecognitionException e) {
        super(SyntaxErrorException.buildErrorMessage(recognizer, e), (Throwable)e);
        if (recognizer == null) {
            throw new NullPointerException("recognizer is marked non-null but is null");
        }
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        if (recognizer instanceof Parser) {
            Token token = e.getOffendingToken();
            this.start = token.getStartIndex();
            this.stop = token.getStopIndex();
            CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
            this.text = tokens == null ? null : tokens.getTokenSource().getInputStream().toString();
        } else {
            CharStream text = (CharStream)recognizer.getInputStream();
            this.start = text.index();
            this.stop = text.index();
            this.text = text.toString();
        }
    }

    private static String buildErrorMessage(Recognizer<?, ?> recognizer, RecognitionException e) {
        String input;
        if (recognizer instanceof Lexer) {
            CharStream charStream = (CharStream)recognizer.getInputStream();
            String token = charStream.getText(Interval.of((int)charStream.index(), (int)charStream.index()));
            return "Token recognition error '" + SyntaxErrorException.escapeWhitespace(token) + "', at pos " + charStream.index();
        }
        CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
        Token token = e.getOffendingToken();
        if (tokens != null) {
            int start = Math.max(token.getStartIndex() - 15, 0);
            int end = token.getStopIndex();
            input = token.getTokenSource().getInputStream().getText(Interval.of((int)start, (int)end));
        } else {
            input = "<unknown input>";
        }
        return "You have an error in your SQL syntax; check the manual for the right syntax to use near '" + SyntaxErrorException.escapeWsAndQuote(input) + "...' at line " + token.getLine() + ", col " + token.getCharPositionInLine();
    }

    private static String escapeWhitespace(String s) {
        StringBuilder buf = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static String escapeWsAndQuote(String s) {
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        return s;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public String getText() {
        return this.text;
    }
}

