/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;

public class MySQLColumnRefFactory
extends OBParserBaseVisitor<ColumnReference>
implements StatementFactory<ColumnReference> {
    private final OBParser.Column_refContext columnRefContext;
    private final OBParser.Column_definition_refContext columnDefinitionRefContext;

    public MySQLColumnRefFactory(@NonNull OBParser.Column_refContext columnRefContext) {
        if (columnRefContext == null) {
            throw new NullPointerException("columnRefContext is marked non-null but is null");
        }
        this.columnRefContext = columnRefContext;
        this.columnDefinitionRefContext = null;
    }

    public MySQLColumnRefFactory(@NonNull OBParser.Column_definition_refContext columnDefinitionRefContext) {
        if (columnDefinitionRefContext == null) {
            throw new NullPointerException("columnDefinitionRefContext is marked non-null but is null");
        }
        this.columnDefinitionRefContext = columnDefinitionRefContext;
        this.columnRefContext = null;
    }

    @Override
    public ColumnReference generate() {
        if (this.columnDefinitionRefContext != null) {
            return (ColumnReference)this.visit((ParseTree)this.columnDefinitionRefContext);
        }
        return (ColumnReference)this.visit((ParseTree)this.columnRefContext);
    }

    @Override
    public ColumnReference visitColumn_ref(OBParser.Column_refContext ctx) {
        String relation;
        String column;
        if (CollectionUtils.isEmpty(ctx.Dot()) && ctx.column_name() != null) {
            return new ColumnReference(ctx, null, null, ctx.column_name().getText());
        }
        String schema = null;
        LinkedList<OBParser.Relation_nameContext> relationNames = new LinkedList<OBParser.Relation_nameContext>(ctx.relation_name());
        LinkedList<OBParser.Mysql_reserved_keywordContext> keywords = new LinkedList<OBParser.Mysql_reserved_keywordContext>(ctx.mysql_reserved_keyword());
        if (ctx.Star() != null) {
            column = ctx.Star().getText();
        } else if (ctx.column_name() != null) {
            column = ctx.column_name().getText();
        } else {
            if (CollectionUtils.isEmpty(keywords)) {
                throw new IllegalStateException("No column name found");
            }
            if (keywords.size() == 1) {
                column = keywords.get(0).getText();
                keywords.removeFirst();
            } else {
                column = keywords.get(1).getText();
                keywords.removeLast();
            }
        }
        if (CollectionUtils.isNotEmpty(keywords)) {
            relation = keywords.get(0).getText();
        } else {
            if (CollectionUtils.isEmpty(relationNames)) {
                throw new IllegalStateException("No relation name found");
            }
            if (relationNames.size() == 1) {
                relation = relationNames.get(0).getText();
                relationNames.removeFirst();
            } else {
                relation = relationNames.get(1).getText();
                relationNames.removeLast();
            }
        }
        if (CollectionUtils.isNotEmpty(relationNames)) {
            schema = relationNames.get(0).getText();
        }
        return new ColumnReference(ctx, schema, relation, column);
    }

    @Override
    public ColumnReference visitColumn_definition_ref(OBParser.Column_definition_refContext ctx) {
        List<OBParser.Relation_nameContext> relations = ctx.relation_name();
        int size = relations.size();
        String relation = --size < 0 ? null : relations.get(size).getText();
        String schema = --size < 0 ? null : relations.get(size).getText();
        return new ColumnReference(ctx, schema, relation, ctx.column_name().getText());
    }
}

