/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLLimitFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectBodyFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.delete.Delete;
import com.oceanbase.tools.sqlparser.statement.delete.DeleteRelation;
import com.oceanbase.tools.sqlparser.statement.delete.MultiDelete;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.mysql.Limit;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLDeleteFactory
extends OBParserBaseVisitor<Delete>
implements StatementFactory<Delete> {
    private final OBParser.Delete_stmtContext deleteStmtContext;

    public MySQLDeleteFactory(@NonNull OBParser.Delete_stmtContext deleteStmtContext) {
        if (deleteStmtContext == null) {
            throw new NullPointerException("deleteStmtContext is marked non-null but is null");
        }
        this.deleteStmtContext = deleteStmtContext;
    }

    @Override
    public Delete generate() {
        return (Delete)this.visit((ParseTree)this.deleteStmtContext);
    }

    @Override
    public Delete visitDelete_stmt(OBParser.Delete_stmtContext deleteCtx) {
        OBParserBaseVisitor factory;
        OBParser.Delete_basic_stmtContext ctx = deleteCtx.delete_basic_stmt();
        Delete delete = null;
        if (ctx.tbl_name() != null) {
            factory = new MySQLFromReferenceFactory(ctx.tbl_name());
            delete = new Delete((ParserRuleContext)ctx, ((MySQLFromReferenceFactory)factory).generate());
        } else if (ctx.multi_delete_table() != null) {
            delete = new Delete((ParserRuleContext)ctx, this.visitMultiTableContext(ctx.multi_delete_table()));
        }
        if (ctx.expr() != null) {
            factory = new MySQLExpressionFactory(ctx.expr());
            delete.setCursor(false);
            delete.setWhere((Expression)factory.generate());
        }
        if (ctx.order_by() != null) {
            factory = new MySQLOrderByFactory(ctx.order_by());
            delete.setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.limit_clause() != null) {
            factory = new MySQLLimitFactory(ctx.limit_clause());
            delete.setLimit((Limit)factory.generate());
        }
        return delete;
    }

    private MultiDelete visitMultiTableContext(OBParser.Multi_delete_tableContext ctx) {
        ArrayList<DeleteRelation> deleteRelations = new ArrayList<DeleteRelation>();
        boolean hasUsing = ctx.USING() != null;
        List<FromReference> tableReferences = MySQLSelectBodyFactory.visitFromList(ctx.table_references());
        for (OBParser.Relation_factor_with_starContext deleteRelation : ctx.relation_with_star_list().relation_factor_with_star()) {
            List<OBParser.Relation_nameContext> relationNames = deleteRelation.relation_name();
            int size = relationNames.size();
            String table = --size < 0 ? null : relationNames.get(size).getText();
            String schema = --size < 0 ? null : relationNames.get(size).getText();
            boolean star = deleteRelation.Star() != null;
            deleteRelations.add(new DeleteRelation(deleteRelation, schema, table, star));
        }
        return new MultiDelete(ctx, deleteRelations, hasUsing, tableReferences);
    }
}

