/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLProjectionFactory
extends OBParserBaseVisitor<Projection>
implements StatementFactory<Projection> {
    private final OBParser.ProjectionContext projectionContext;

    public MySQLProjectionFactory(@NonNull OBParser.ProjectionContext projectionContext) {
        if (projectionContext == null) {
            throw new NullPointerException("projectionContext is marked non-null but is null");
        }
        this.projectionContext = projectionContext;
    }

    @Override
    public Projection generate() {
        return (Projection)this.visit((ParseTree)this.projectionContext);
    }

    @Override
    public Projection visitProjection(OBParser.ProjectionContext ctx) {
        if (ctx.Star() != null) {
            return new Projection(ctx.Star());
        }
        MySQLExpressionFactory factory = new MySQLExpressionFactory(ctx.expr());
        String columnLabel = null;
        if (ctx.column_label() != null) {
            columnLabel = ctx.column_label().getText();
        } else if (ctx.STRING_VALUE() != null) {
            columnLabel = ctx.STRING_VALUE().getText();
        }
        return new Projection(ctx, (Expression)factory.generate(), columnLabel);
    }
}

