/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleAlterTableActionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.alter.table.AlterTable;
import com.oceanbase.tools.sqlparser.statement.alter.table.AlterTableAction;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleAlterTableFactory
extends OBParserBaseVisitor<AlterTable>
implements StatementFactory<AlterTable> {
    private final ParserRuleContext parserRuleContext;

    public OracleAlterTableFactory(@NonNull OBParser.Alter_table_stmtContext alterTableStmtContext) {
        if (alterTableStmtContext == null) {
            throw new NullPointerException("alterTableStmtContext is marked non-null but is null");
        }
        this.parserRuleContext = alterTableStmtContext;
    }

    @Override
    public AlterTable generate() {
        return (AlterTable)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public AlterTable visitAlter_table_stmt(OBParser.Alter_table_stmtContext ctx) {
        AlterTable alterTable;
        String relation = OracleFromReferenceFactory.getRelation(ctx.relation_factor());
        if (ctx.alter_table_actions() != null) {
            List<AlterTableAction> actions = ctx.alter_table_actions().alter_table_action().stream().map(c -> new OracleAlterTableActionFactory((OBParser.Alter_table_actionContext)((Object)c)).generate()).collect(Collectors.toList());
            alterTable = new AlterTable(ctx, relation, actions);
        } else {
            alterTable = new AlterTable(ctx, relation, Collections.singletonList(new OracleAlterTableActionFactory(ctx.alter_column_group_option()).generate()));
        }
        if (ctx.EXTERNAL() != null) {
            alterTable.setExternal(true);
        }
        alterTable.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        alterTable.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        return alterTable;
    }
}

