/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnGroupElementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFetchFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OraclePartitionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSelectBodyFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleTableElementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleTableOptionsFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleCreateTableFactory
extends OBParserBaseVisitor<CreateTable>
implements StatementFactory<CreateTable> {
    private final OBParser.Create_table_stmtContext createTableStmtContext;

    public OracleCreateTableFactory(@NonNull OBParser.Create_table_stmtContext createTableStmtContext) {
        if (createTableStmtContext == null) {
            throw new NullPointerException("createTableStmtContext is marked non-null but is null");
        }
        this.createTableStmtContext = createTableStmtContext;
    }

    @Override
    public CreateTable generate() {
        return (CreateTable)this.visit((ParseTree)this.createTableStmtContext);
    }

    @Override
    public CreateTable visitCreate_table_stmt(OBParser.Create_table_stmtContext ctx) {
        CreateTable createTable = new CreateTable((ParserRuleContext)ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()));
        createTable.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        createTable.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        if (ctx.special_table_type().GLOBAL() != null && ctx.special_table_type().TEMPORARY() != null) {
            createTable.setGlobal(true);
            createTable.setTemporary(true);
        } else if (ctx.special_table_type().EXTERNAL() != null) {
            createTable.setExternal(true);
        }
        if (ctx.table_element_list() != null) {
            createTable.setTableElements(ctx.table_element_list().table_element().stream().map(c -> new OracleTableElementFactory((OBParser.Table_elementContext)((Object)c)).generate()).collect(Collectors.toList()));
        } else {
            Select as = new Select((ParserRuleContext)ctx.subquery(), new OracleSelectBodyFactory(ctx.subquery()).generate());
            if (ctx.order_by() != null) {
                as.setOrderBy(new OracleOrderByFactory(ctx.order_by()).generate());
            }
            if (ctx.fetch_next_clause() != null) {
                as.setFetch(new OracleFetchFactory(ctx.fetch_next_clause()).generate());
            }
            createTable.setAs(as);
        }
        if (ctx.on_commit_option() != null) {
            if (ctx.on_commit_option().DELETE() != null) {
                createTable.setCommitOption(ctx.on_commit_option().DELETE().getText());
            } else if (ctx.on_commit_option().PRESERVE() != null) {
                createTable.setCommitOption(ctx.on_commit_option().PRESERVE().getText());
            }
        }
        if (ctx.table_option_list() != null) {
            createTable.setTableOptions(new OracleTableOptionsFactory(ctx.table_option_list()).generate());
        }
        if (ctx.partition_option() != null) {
            createTable.setPartition(new OraclePartitionFactory(ctx.partition_option()).generate());
        } else if (ctx.auto_partition_option() != null) {
            createTable.setPartition(new OraclePartitionFactory(ctx.auto_partition_option()).generate());
        }
        if (ctx.with_column_group() != null) {
            List<ColumnGroupElement> columnGroupElements = ctx.with_column_group().column_group_list().column_group_element().stream().map(c -> new OracleColumnGroupElementFactory((OBParser.Column_group_elementContext)((Object)c)).generate()).collect(Collectors.toList());
            createTable.setColumnGroupElements(columnGroupElements);
        }
        return createTable;
    }
}

